/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.utils;

import jakarta.ws.rs.InternalServerErrorException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Properties;
import org.gcube.common.iam.D4ScienceIAMClient;
import org.gcube.common.iam.D4ScienceIAMClientAuthn;
import org.gcube.common.security.secrets.AccessTokenSecret;
import org.gcube.common.security.secrets.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthorizationUtils {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationUtils.class);
    protected static final String CLIENT_ID_SECRET_FILENAME = "config.properties";
    protected static final String CLIENT_ID_PROPERTY_NAME = "clientId";

    private static Map.Entry<String, String> getClientIdAndClientSecret(String context) {
        try {
            Properties properties = new Properties();
            ClassLoader classLoader = AuthorizationUtils.class.getClassLoader();
            URL url = classLoader.getResource("config.properties");
            logger.trace("Going to read {} at {}", (Object)"config.properties", (Object)url.toString());
            InputStream input = classLoader.getResourceAsStream("config.properties");
            properties.load(input);
            String clientId = null;
            if (!properties.containsKey("clientId")) {
                throw new InternalServerErrorException("Unable to retrieve clientId");
            }
            clientId = properties.getProperty("clientId");
            int index = context.indexOf(47, 1);
            String root = context.substring(0, index == -1 ? context.length() : index);
            String clientSecret = properties.getProperty(root);
            AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(clientId, clientSecret);
            return entry;
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Unable to retrieve Application Token for context " + context, (Throwable)e);
        }
    }

    private static String getAccessTokenString(String clientId, String clientSecret, String context) throws Exception {
        int index = context.indexOf(47, 1);
        String root = context.substring(0, index == -1 ? context.length() : index);
        D4ScienceIAMClient iamClient = D4ScienceIAMClient.newInstance((String)root);
        D4ScienceIAMClientAuthn d4ScienceIAMClientAuthn = iamClient.authenticate(clientId, clientSecret, context);
        return d4ScienceIAMClientAuthn.getAccessTokenString();
    }

    public static Secret getSecret(String context) throws Exception {
        Map.Entry entry = AuthorizationUtils.getClientIdAndClientSecret((String)context);
        String accessToken = AuthorizationUtils.getAccessTokenString((String)((String)entry.getKey()), (String)((String)entry.getValue()), (String)context);
        AccessTokenSecret secret = new AccessTokenSecret(accessToken, context);
        return secret;
    }
}

