package org.gcube.resourcemanagement.rest;

import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;

import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response.ResponseBuilder;
import jakarta.ws.rs.core.UriInfo;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@RequestHeaders ({
	  @RequestHeader( name = "Authorization", description = "Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")
})
public class BaseREST {
	
	/** Logger instance for this class */
	protected final Logger logger = LoggerFactory.getLogger(this.getClass());
	
	/** Content type for JSON with UTF-8 charset */
	public static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json;charset=UTF-8";
	/** Content type for JSON API */
	public static final String APPLICATION_JSON_API = "application/vnd.api+json";
	/** Key name for count values in JSON responses */
	public static final String COUNT_KEY = "count";
	/** Query parameter name for purge operations */
	public static final String PURGE_QUERY_PARAMETER = "purge";
	
	/** HTTP headers context */
	@Context
	protected HttpHeaders httpHeaders;
	
	/** URI info context */
	@Context
	protected UriInfo uriInfo;
	
	/** Header name for location header */
	protected static final String LOCATION_HEADER = "Location";
	
	/**
	 * Add a location header to the response builder
	 * @param responseBuilder the response builder to modify
	 * @param id the resource identifier to append to the location
	 * @return the modified response builder
	 */
	protected ResponseBuilder addLocation(ResponseBuilder responseBuilder, String id) {
		return responseBuilder.header(LOCATION_HEADER,
				String.format("%s/%s", uriInfo.getAbsolutePath().toString(), id));
	}
	
	/**
	 * Create a JSON string containing a count value
	 * @param count the count value to include
	 * @return JSON string with the count
	 */
	protected String createCountJson(int count) {
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append("{\"");
		stringBuilder.append(COUNT_KEY);
		stringBuilder.append("\":");
		stringBuilder.append(count);
		stringBuilder.append("}");
		return stringBuilder.toString();
	}
	
	/**
	 * Set the accounting method name for tracking operations
	 * @param method the method name to set for accounting
	 */
	protected void setAccountingMethod(String method) {
		InnerMethodName.set(method);
		logger.info("{}", uriInfo.getAbsolutePath());
	}
	
//	protected void setAccountingMethod(Method method, String type) {
//		StringBuffer accountingMethod = new StringBuffer();
//		accountingMethod.append(method.getPrefix());
//		accountingMethod.append(type);
//		accountingMethod.append(method.getSuffix());
//		setAccountingMethod(accountingMethod.toString());
//	}
//	
//	private ServerRequestInfo initRequestInfo(ServerRequestInfo requestInfo) {
//		requestInfo.setUriInfo(uriInfo);
//		RequestUtility.getRequestInfo().set(requestInfo);
//		return requestInfo;
//	}
//	
//	protected ServerRequestInfo initRequestInfo(int offset, int limit) {
//		ServerRequestInfo requestInfo = new ServerRequestInfo(offset, limit);
//		return initRequestInfo(requestInfo);
//	}
//	
//	protected ServerRequestInfo initRequestInfo() {
//		ServerRequestInfo requestInfo = new ServerRequestInfo();
//		return initRequestInfo(requestInfo);
//	}
	
}
