/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.manager.webapp.context;

import java.util.Objects;
import java.util.UUID;
import org.gcube.common.gxrest.response.outbound.ErrorCode;
import org.gcube.common.gxrest.response.outbound.LocalCodeException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.resourcemanagement.manager.io.rs.RMDeleteContextCode;
import org.gcube.resourcemanagement.manager.webapp.context.Queries;
import org.gcube.resourcemanagement.manager.webapp.context.RequestToResourceRegistry;
import org.gcube.resourcemanagement.manager.webapp.context.ResponseFromResourceRegistry;

public final class DeleteRequest
extends RequestToResourceRegistry {
    final UUID context;

    private DeleteRequest(UUID context) {
        this.context = context;
    }

    public static DeleteRequest fromUUID(UUID context) {
        Objects.requireNonNull(context);
        return new DeleteRequest(context);
    }

    public void validate() throws LocalCodeException {
        Queries queries = new Queries(this.getContextClient(), this.getRegistryClient());
        if (!queries.contextExists(this.context)) {
            throw new LocalCodeException((ErrorCode)RMDeleteContextCode.CONTEXT_DOES_NOT_EXIST);
        }
        if (!queries.isContextEmpty(this.context)) {
            throw new LocalCodeException((ErrorCode)RMDeleteContextCode.CONTEXT_IS_NOT_EMPTY);
        }
    }

    protected ResponseFromResourceRegistry send() {
        try {
            boolean deleted = this.getContextClient().delete(this.context);
            if (!deleted) {
                return ResponseFromResourceRegistry.fromErrorCode((ErrorCode)RMDeleteContextCode.GENERIC_ERROR_FROM_RR);
            }
        }
        catch (ResourceRegistryException e) {
            return ResponseFromResourceRegistry.fromErrorCode((ErrorCode)RMDeleteContextCode.GENERIC_ERROR_FROM_RR);
        }
        return ResponseFromResourceRegistry.newSuccessResponseWithMessage((String)"Context successfully deleted", null);
    }
}

