/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.resource;

import jakarta.ws.rs.WebApplicationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.resourcemanagement.analyser.InstanceAnalyser;
import org.gcube.resourcemanagement.analyser.InstanceAnalyserFactory;
import org.gcube.resourcemanagement.resource.Instance;

public class DerivatedRelatedResourceGroup<I extends Instance>
implements Comparable<DerivatedRelatedResourceGroup<I>> {
    @JsonIgnore
    protected Resource ancestor;
    @JsonIgnore
    protected final ObjectMapper mapper;
    @JsonIgnore
    protected final Class<I> instanceClass;
    protected String name;
    protected String description;
    protected int min;
    protected Integer max;
    protected Set<I> instances;
    @JsonIgnore
    protected List<Resource> relatedResources;

    public DerivatedRelatedResourceGroup(Class<I> instanceClass) {
        this.instanceClass = instanceClass;
        this.mapper = new ObjectMapper();
    }

    @JsonIgnore
    public Class<I> getInstanceClass() {
        return this.instanceClass;
    }

    @JsonIgnore
    public Resource getAncestor() {
        return this.ancestor;
    }

    @JsonIgnore
    public void setAncestor(Resource ancestor) {
        this.ancestor = ancestor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    @JsonIgnore
    public List<Resource> getRelatedResources() {
        return this.relatedResources;
    }

    @JsonIgnore
    public void setRelatedResources(List<Resource> relatedResources) {
        this.relatedResources = relatedResources;
    }

    public Set<I> getInstances() throws WebApplicationException, ResourceRegistryException {
        if (this.instances == null && this.relatedResources != null) {
            this.instances = Instance.getAsInstances(this.instanceClass, this.relatedResources);
            if (this.min == 1 && this.max == 1 && this.relatedResources.size() == 1) {
                Resource r = this.relatedResources.iterator().next();
                InstanceAnalyser<Resource, Instance> analyser = InstanceAnalyserFactory.getInstanceAnalyser(r.getTypeName(), r.getID());
                analyser.setAncestor(this.ancestor);
                analyser.setResource(r);
                Instance inst = analyser.getInstance();
                this.instances.add(inst);
            }
        }
        return this.instances;
    }

    public void setInstances(Set<I> instances) {
        this.instances = instances;
    }

    public void addInstance(I instance) {
        if (this.instances == null) {
            this.instances = new HashSet<I>();
        }
        this.instances.add(instance);
    }

    public void addInstances(Collection<I> instances) {
        if (this.instances == null) {
            this.instances = new HashSet<I>();
        }
        this.instances.addAll(instances);
    }

    public String toString() {
        try {
            return this.mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public int compareTo(DerivatedRelatedResourceGroup<I> o) {
        return this.getName().compareTo(o.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DerivatedRelatedResourceGroup other = (DerivatedRelatedResourceGroup)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

