/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import java.net.URI;
import java.util.Date;

import org.gcube.com.fasterxml.jackson.annotation.JsonFormat;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.resourcemanagement.model.impl.entities.facets.EventFacetImpl;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Event_Facet
 */
@JsonDeserialize(as=EventFacetImpl.class)
public interface EventFacet extends Facet {

	public static final String NAME = "EventFacet"; // EventFacet.class.getSimpleName();
	public static final String DESCRIPTION = "Event Facet";
	public static final String VERSION = "1.0.0";
	
	@JsonFormat(shape= JsonFormat.Shape.STRING, pattern = Element.DATETIME_PATTERN)
	@ISProperty(mandatory=true, nullable=false)
	public Date getDate();
	
	public void setDate(Date date);
	
	@ISProperty(mandatory=true, nullable=false)
	public String getValue();
	
	public void setValue(String value);

	@ISProperty
	public URI getSchema();
	
	public void setSchema(URI schema);
}
