/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import java.net.URI;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.resourcemanagement.model.impl.entities.facets.CoverageFacetImpl;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Coverage_Facet
 */
@JsonDeserialize(as=CoverageFacetImpl.class)
public interface CoverageFacet extends Facet {
	
	public static final String NAME = "CoverageFacet"; // CoverageFacet.class.getSimpleName();
	public static final String DESCRIPTION = "Collect any \"extent\"-related information.";
	public static final String VERSION = "1.0.0";
	
	@ISProperty(mandatory=true, nullable=false)
	public String getValue();
	
	public void setValue(String value);

	@ISProperty(mandatory=true, nullable=false)
	public URI getSchema();
	
	public void setSchema(URI schema);

}
