/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.resources;

import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaEntry;
import org.gcube.informationsystem.types.annotations.ResourceSchemaRelatedEntry;
import org.gcube.resourcemanagement.model.impl.entities.resources.SchemaImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ContactFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.DescriptiveMetadataFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.JSONSchemaFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SchemaFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SubjectFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.XSDSchemaFacet;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasContact;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.IsCompliantWith;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Schema
 */
@JsonDeserialize(as=SchemaImpl.class)
@ResourceSchema(
	facets={
		@ResourceSchemaEntry(relation=IsIdentifiedBy.class, facet=SchemaFacet.class, min=1),
		@ResourceSchemaEntry(relation=IsIdentifiedBy.class, facet=JSONSchemaFacet.class),
		@ResourceSchemaEntry(relation=IsIdentifiedBy.class, facet=XSDSchemaFacet.class),
		@ResourceSchemaEntry(relation=HasContact.class, facet=ContactFacet.class, min=1),
		@ResourceSchemaEntry(facet=DescriptiveMetadataFacet.class),
		@ResourceSchemaEntry(facet=SubjectFacet.class)
	},
	resources = {
		@ResourceSchemaRelatedEntry(source=Dataset.class, relation=IsCompliantWith.class, target=Schema.class, description="Any schema characterising the content of the dataset, e.g. the schema describing the 'columns' of a CSV-based dataset.")
	}
)
public interface Schema extends GCubeResource {
	
	public static final String NAME = "Schema"; // Schema.class.getSimpleName();
	public static final String DESCRIPTION = "Any reference schema to be used to specify values compliant with it. Examples include controlled vocabularies, ontologies, etc.";
	public static final String VERSION = "1.0.0";
}
