/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.resources;

import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaEntry;
import org.gcube.informationsystem.types.annotations.ResourceSchemaRelatedEntry;
import org.gcube.resourcemanagement.model.impl.entities.resources.ConcreteDatasetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.AccessPointFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.ContactFacet;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasMaintainer;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.IsPartOf;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;


/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Concrete_Dataset
 */
@JsonDeserialize(as=ConcreteDatasetImpl.class)
@ResourceSchema(
	facets={
		@ResourceSchemaEntry(relation=HasMaintainer.class, facet=ContactFacet.class, min=1, description="The contact information of the entity responsible for the maintenance of the concrete dataset"),
		@ResourceSchemaEntry(facet=AccessPointFacet.class, min=1, description="The access point to use for having access to the concrete dataset. The embargoState can be modeled through the access policy defined in the consistsOf relation.")
	},
	resources = {
		@ResourceSchemaRelatedEntry(source=ConcreteDataset.class, relation=IsPartOf.class, target=Dataset.class, description="The reference to the 'incarnations'/'manifestations' contributing to a dataset."),
	}
)
public interface ConcreteDataset extends Dataset {

	public static final String NAME = "ConcreteDataset"; // ConcreteDataset.class.getSimpleName();
	public static final String DESCRIPTION = "Any incarnation/manifestation of a dataset or part of it";
	public static final String VERSION = "1.0.0";
	
}
