package org.gcube.resourcemanagement.model.reference.relations.consistsof;

import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.HasActionImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ActionFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * Relation among a {@link Service} and its {@link ActionFacet}.
 * 
 * @author Manuele Simi (ISTI CNR)
 *
 */
@Abstract
@JsonDeserialize(as=HasActionImpl.class)
public interface HasAction<Out extends Service, In extends ActionFacet> extends ConsistsOf<Out, In> {
	
	public static final String NAME = "HasAction"; 
	
}
