package org.gcube.resourcemanagement.model.reference.properties;

import java.net.URI;

import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.resourcemanagement.model.impl.properties.ValueSchemaImpl;
import org.gcube.resourcemanagement.model.reference.properties.utilities.PropertyValidator;
import org.gcube.resourcemanagement.model.reference.properties.utilities.ValidatedTypedProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.Validation;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * A property with an {@link URI} as value
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=ValueSchemaImpl.class)
public interface ValueSchema extends GCubeProperty, ValidatedTypedProperty<URI,String> {

	public static final String NAME = "ValueSchema"; //ValueSchema.class.getSimpleName();
	
	@Override
	default Validation validate() {
		return new SchemaValidator().validate(this);
	}
	
	/**
	 * Validator for {@link ValueSchema} properties. 
	 * @author Manuele Simi (ISTI CNR)
	 *
	 */
	class SchemaValidator implements PropertyValidator<ValueSchema> {

		@Override
		public Validation validate(ValueSchema property) {
			//TODO validate the string against the URI!
			
			return Validation.success("Accepted!");
		}
	}
	
	
	@ISProperty
	@Override
	public String getValue();
	
	@Override
	public void setValue(String value);
	
	@ISProperty
	@Override
	public URI getType();
	
	@Override
	public void setType(URI type);
	
}
