/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.resources;

import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaEntry;
import org.gcube.informationsystem.types.annotations.ResourceSchemaRelatedEntry;
import org.gcube.resourcemanagement.model.impl.entities.resources.SiteImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ContactFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.IdentifierFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.LocationFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.NetworkingFacet;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasContact;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasMaintainer;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasManager;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Hosts;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.IsOwnedBy;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Site
 */
@JsonDeserialize(as=SiteImpl.class)
@ResourceSchema(
	facets={
		@ResourceSchemaEntry(relation=IsIdentifiedBy.class, facet=IdentifierFacet.class, min=1, description="The Site Identifier."),
		@ResourceSchemaEntry(relation=HasContact.class, facet=ContactFacet.class, min=1, description="The main contact for the Site."),
		@ResourceSchemaEntry(relation=HasMaintainer.class, facet=ContactFacet.class, min=1, description="Contact information of the maintainer of the Site."),
		@ResourceSchemaEntry(relation=HasManager.class, facet=ContactFacet.class, min=1, description="Contact information of the Site Manager."),
		@ResourceSchemaEntry(facet=LocationFacet.class, min=1),
		@ResourceSchemaEntry(facet=NetworkingFacet.class, min=1),
	},
	resources= {
		@ResourceSchemaRelatedEntry(source=Site.class, relation=IsOwnedBy.class, target=Actor.class),
		@ResourceSchemaRelatedEntry(source=Site.class, relation=Hosts.class, target=Service.class)
	}
)
public interface Site extends GCubeResource {

	public static final String NAME = "Site"; // Site.class.getSimpleName();
	public static final String DESCRIPTION = "An entity representing the location (physical or virtual) hosting and providing the resources associated with it.";
	public static final String VERSION = "1.0.0";
	
}
