/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.model.reference.entity.properties;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.informationsystem.model.reference.annotations.ISProperty;
import org.gcube.informationsystem.model.reference.embedded.Embedded;
import org.gcube.resourcemanagement.model.impl.entity.properties.RegexPropertyImpl;
import org.gcube.resourcemanagement.model.reference.entity.properties.GCubeEmbedded;
import org.gcube.resourcemanagement.model.reference.entity.properties.PropertyValidator;
import org.gcube.resourcemanagement.model.reference.entity.properties.ValidatedTypedProperty;
import org.gcube.resourcemanagement.model.reference.entity.properties.Validation;

@JsonDeserialize(as=RegexPropertyImpl.class)
public interface RegexProperty
extends Embedded,
GCubeEmbedded,
ValidatedTypedProperty<String, String> {
    public static final String NAME = "RegexProperty";

    @Override
    default public Validation validate() {
        return new RegexValidator().validate(this);
    }

    @Override
    @ISProperty
    public String getValue();

    @Override
    public void setValue(String var1);

    @Override
    @ISProperty
    public String getType();

    @Override
    public void setType(String var1);

    public static class RegexValidator
    implements PropertyValidator<RegexProperty> {
        @Override
        public Validation validate(RegexProperty property) {
            if (Objects.isNull(property.getValue())) {
                return Validation.fail("The value of the regex property is not set.");
            }
            if (Objects.isNull(property.getType())) {
                return Validation.fail("The type of the regex property is not set.");
            }
            Pattern pattern = Pattern.compile(property.getType());
            Matcher matcher = pattern.matcher(property.getValue());
            return matcher.find() ? Validation.success("Accepted!") : Validation.fail(property.getValue() + " was not a valid match!");
        }
    }
}

