package org.gcube.resourcemanagement.model.reference.entity.properties;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.gcube.informationsystem.model.reference.annotations.ISProperty;
import org.gcube.informationsystem.model.reference.embedded.Embedded;
import org.gcube.resourcemanagement.model.impl.entity.properties.RegexPropertyImpl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * A property validated with a regular expression.
 * 
 * @author Manuele Simi (ISTI CNR)
 *
 */
@JsonDeserialize(as=RegexPropertyImpl.class)
public interface RegexProperty extends Embedded, GCubeEmbedded, ValidatedTypedProperty<String, String> {

	public static final String NAME = "RegexProperty"; // RegexProperty.class.getSimpleName();

	/* (non-Javadoc)
	 * @see org.gcube.informationsystem.model.reference.embedded.ValidatedTypedProperty#validate()
	 */
	@Override
	default Validation validate() {
		return new RegexValidator().validate(this);
	}
	
	/**
	 * Validator for {@link RegexProperty} properties. 
	 * @author Manuele Simi (ISTI CNR)
	 *
	 */
	class RegexValidator implements PropertyValidator<RegexProperty> {

		/* (non-Javadoc)
		 * @see org.gcube.informationsystem.model.reference.embedded.PropertyValidator#validate(org.gcube.informationsystem.model.reference.embedded.TypedProperty)
		 */
		@Override
		public Validation validate(RegexProperty property) {
			if (Objects.isNull(property.getValue()))
				return Validation.fail("The value of the regex property is not set.");
			if (Objects.isNull(property.getType()))
				return Validation.fail("The type of the regex property is not set.");
			
			Pattern pattern = Pattern.compile(property.getType());
		    Matcher matcher = pattern.matcher(property.getValue());
			return matcher.find() ? 
					Validation.success("Accepted!") : Validation.fail(property.getValue() + " was not a valid match!");
		}
	}
	
	
	@ISProperty
	@Override
	public String getValue();
	
	@Override
	public void setValue(String value);
	
	@ISProperty
	@Override
	public String getType();
	
	@Override
	public void setType(String type);
	
}
