/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.warmanagementportlet.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEServiceQuery;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Software;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.warmanagementportlet.client.data.WARShortInformation;
import org.gcube.portlets.user.warmanagementportlet.client.rpc.ManagementService;
import org.gcube.portlets.user.warmanagementportlet.client.rpc.ManagementServiceException;

public class ManagementServiceImpl
extends RemoteServiceServlet
implements ManagementService {
    private static final long serialVersionUID = 7258354450454637807L;
    protected static Logger logger = Logger.getLogger(ManagementServiceImpl.class);
    protected ISClient client;

    protected ISClient getClient() throws Exception {
        if (this.client == null) {
            this.client = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        return this.client;
    }

    protected ASLSession getASLSession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String sessionID = httpSession.getId();
        String user = (String)httpSession.getAttribute("username");
        if (user == null) {
            logger.error((Object)"WAR MANAGEMENT PORTLET STARTING IN TEST MODE - NO USER FOUND");
            user = "test.user";
            httpSession.setAttribute("username", (Object)user);
            ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);
            session.setScope("/gcube/devsec");
            return session;
        }
        logger.trace((Object)("user found in session " + user));
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public ArrayList<WARShortInformation> getWarList() throws ManagementServiceException {
        logger.info((Object)"getWarList");
        try {
            ASLSession aslSession = this.getASLSession();
            GCUBEScope scope = aslSession.getScope();
            ISClient client = this.getClient();
            GCUBEServiceQuery query = (GCUBEServiceQuery)client.getQuery(GCUBEServiceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Class", "WebApp")});
            ArrayList<WARShortInformation> webApplications = new ArrayList<WARShortInformation>();
            logger.trace((Object)"Queriyng the IS");
            for (GCUBEService service : client.execute((ISQuery)query, scope)) {
                Software software = (Software)service.getPackages().get(0);
                String version = software.getVersion();
                webApplications.add(new WARShortInformation(service.getID(), service.getServiceName(), service.getDescription(), version));
            }
            logger.trace((Object)("Found " + webApplications.size() + " Wars"));
            return webApplications;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        ConsoleAppender ca = new ConsoleAppender((Layout)new SimpleLayout());
        ca.setThreshold((Priority)Level.ALL);
        ca.activateOptions();
        logger.addAppender((Appender)ca);
        logger.setLevel(Level.ALL);
    }
}

