package org.gcube.portlets.user.geoexplorer.server;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * use: <serverName>/<servletName>?geoserver=<geoserverUrl>&layer=<layerCompleteName>
 * sample: http://127.0.0.1:8888/testgisviewer/MapPreviewGenerator?&layer=aquamaps:primProdMean&style=primprod_style
*/
public class MapPreviewGenerator extends HttpServlet {

	private static final long serialVersionUID = 1L;
	private static final String NAME_IMG_ERROR = "resources/error.png";
	private static final Color COLOR_BLACK = new Color(10, 10, 10);
	private static Font FONT = new Font("Monospaced", Font.BOLD, 12);
	private static int w = 168;  // proportional to 503x250
	private static int h = 95;  // proportional to 503x250 no
	
	// the true marble wms request is not used, a static image is well performant
	//private static final String LINK_TRUE_MARBLE = "http://geoserver.d4science-ii.research-infrastructures.eu:80/geoserver/wms?SERVICE=WMS&version=1.1.0&REQUEST=GetMap&LAYERS=aquamaps:TrueMarble.16km.2700x1350&BBOX=-165.5859375,-86.484375,180.0,89.296875&WIDTH="+w+"&HEIGHT="+h+"&SRS=EPSG:4326&FORMAT=image/png";	
	//private static final String LINK_TRUE_MARBLE = "http://iceds.ge.ucl.ac.uk/cgi-bin/icedswms?SERVICE=WMS&version=1.1.0&REQUEST=GetMap&LAYERS=bluemarble_1&BBOX=-165.5859375,-86.484375,180.0,89.296875&WIDTH="+w+"&HEIGHT="+h+"&SRS=EPSG:4326&FORMAT=image/png";
	
	private static final String NAME_IMG_TRUE_MARBLE = "resources/baseLayer.png";

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException {

		try {
			// get parameters
			String outputFormat = "image/png";
			String outputExtension = "png";
			
			String bbox = "-165.5859375,-86.484375,180.0,89.296875";
			String width = ""+w;
			String height = ""+h;
			
			String geoserver = request.getParameter("geoserver");
			String layer = request.getParameter("layer");

			String url = geoserver
					+ "?SERVICE=WMS&version=1.1.0"
					+ "&REQUEST=GetMap"
					+ "&LAYERS=" + layer
					//+ "&STYLES=" + style
					+ "&BBOX=" + bbox
					+ "&WIDTH=" + width
					+ "&HEIGHT=" + height
					+ "&SRS=EPSG:4326"
					+ "&FORMAT=image/png"
					+ "&TRANSPARENT=true";

			System.out.println("url>"+url);

			InputStream inputStremTrueMarble = MapPreviewGenerator.class.getResourceAsStream(NAME_IMG_TRUE_MARBLE);
			BufferedImage imgTrueMarble = ImageIO.read(inputStremTrueMarble);
			
			BufferedImage img = ImageIO.read(new URL(url));
			img = overlayImage(img, imgTrueMarble);
			
			//--Send the image data to response  
			response.setContentType(outputFormat);  
			OutputStream outputStream = response.getOutputStream();  
			ImageIO.write(img, outputExtension, outputStream);
			outputStream.close();
		} catch (MalformedURLException e) {
			//e.printStackTrace();
			showErrorImage(response, e.toString());
		} catch (IOException e) {
			//e.printStackTrace();
			showErrorImage(response, "Error: I/O Exception.");
		} catch (Exception e) {
			e.printStackTrace();
			showErrorImage(response, "Error: Invalid parameters.");
		}
	}

	private BufferedImage overlayImage(BufferedImage fgImage, BufferedImage bgImage) {
        /**Create a Graphics  from the background image**/
        Graphics2D g = bgImage.createGraphics();
        /**Set Antialias Rendering**/
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

        g.drawImage(bgImage, 0, 0, null);
 
        g.drawImage(fgImage, 0, 0, null);
 
        g.dispose();
        
        return bgImage;
	}

	private void showErrorImage(HttpServletResponse response, String message) {
		try {
			// get an error image
			InputStream inputStremLogo = MapPreviewGenerator.class.getResourceAsStream(NAME_IMG_ERROR);
			BufferedImage img = ImageIO.read(inputStremLogo);
			// add an error message
			Graphics g = img.getGraphics();
			g.setColor(COLOR_BLACK);
			g.setFont(FONT);
			g.drawString(message, 55, img.getHeight()/2);

			// send the image data to response  
			response.setContentType("image/png");
			OutputStream outputStream;
			outputStream = response.getOutputStream();
			ImageIO.write(img, "png", outputStream);  
			outputStream.close();
		} catch (Exception e) {
			e.printStackTrace();
		}  
	}
}