/**
 * 
 */
package org.gcube.portlets.user.geoexplorer.server;

import javax.servlet.http.HttpSession;

import org.gcube.common.geoserverinterface.GeoCallerConfigurationInterface;
import org.gcube.portlets.user.geoexplorer.client.beans.LayerItem;

import com.extjs.gxt.ui.client.data.PagingLoadConfig;
import com.extjs.gxt.ui.client.data.PagingLoadResult;


/**
 * @author ceras
 *
 */
public class DefaultGeoExplorerServiceImpl extends GeoExplorerServiceImpl {

	private static final long serialVersionUID = 7965911406156513171L;

	//DEVELOPMENT ENVIRONMENT
//	public static String geoServerUrl="http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver";
//	public static String geoNetworkUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geonetwork";

	//PRODUCTION ENVIRONMENT
	
	public static String geoServerUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver";
	public static String geoNetworkUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork";
//	
//	public static String geoServerWMSUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver/wms";
//	public static String geoServerGWCUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver/gwc/service/wms";
//	public static String urlGroup = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver/rest/layergroups.xml";
	
	
	private static final String geoNetworkUser = "admin";
	private static final String geoNetworkPwd = "admin";
	private static final String geoServerUser = GeoCallerConfigurationInterface.GEOSERVEGLOBALUSERNAME;
	private static final String geoServerPwd = GeoCallerConfigurationInterface.GEOSERVERGLOBALPASSWORD;

	protected GeoExplorerServiceParameters parameters;

	@Override
	protected GeoExplorerServiceParameters getParameters(HttpSession httpSession) throws Exception {
		if (parameters == null) parameters = new GeoExplorerServiceParameters(geoServerUrl, geoServerUser, geoServerPwd, geoNetworkUrl, geoNetworkUser, geoNetworkPwd);
		return parameters;
	}

}
