/**
 * 
 */
package org.gcube.portlets.user.geoexplorer.client;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.geoexplorer.client.beans.LayerItem;
import org.gcube.portlets.user.geoexplorer.client.resources.Images;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style.SelectionMode;
import com.extjs.gxt.ui.client.data.BaseFilterConfig;
import com.extjs.gxt.ui.client.data.BaseFilterPagingLoadConfig;
import com.extjs.gxt.ui.client.data.BasePagingLoadConfig;
import com.extjs.gxt.ui.client.data.BasePagingLoader;
import com.extjs.gxt.ui.client.data.BaseStringFilterConfig;
import com.extjs.gxt.ui.client.data.FilterConfig;
import com.extjs.gxt.ui.client.data.FilterPagingLoadConfig;
import com.extjs.gxt.ui.client.data.ListLoadResult;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.PagingLoader;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.CheckBoxSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.filters.Filter;
import com.extjs.gxt.ui.client.widget.grid.filters.GridFilters;
import com.extjs.gxt.ui.client.widget.grid.filters.StringFilter;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.PagingToolBar;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;

/**
 * @author ceras
 *
 */
public class LayersGrid extends LayoutContainer {

	private static final int PAGE_SIZE = 50;
	private GeoExplorerServiceAsync service;
	private Grid<LayerItem> grid;
	private CheckBoxSelectionModel<LayerItem> selectionModel;
	private LayersGridHandler layersGridListener;
	protected GridFilters filters;
	private String title;
	private static final ImageResource ICON_OPEN_GIS_VIEWER = GeoExplorer.resources.iconGisWorld();
	private boolean filterActive = false;
	private Button searchCancelButton;

	/**
	 * 
	 */
	public LayersGrid(String title, LayersGridHandler layersGridListener, GeoExplorerServiceAsync service) {
		super();
		this.layersGridListener = layersGridListener;
		this.service = service;
		this.title = title;
	}

	protected void onRender(Element parent, int index) {
		super.onRender(parent, index);

		setLayout(new FitLayout());

		ContentPanel panel = new ContentPanel();
		//panel.setFrame(true);
		//panel.setCollapsible(true);
		//panel.setAnimCollapse(false);

		//		panel.setIcon(Resources.ICONS.table());
		//panel.setHeading(title);
		panel.setHeaderVisible(false);
		panel.setLayout(new FitLayout());
		add(panel);
		layersGridListener.layersGridRendered();
	}

	/**
	 * @return
	 */
	private ToolBar createToolBar() {
		final ToggleButton tb1 = new ToggleButton("Title");
		final ToggleButton tb2 = new ToggleButton("Name");
		final ToggleButton tb3 = new ToggleButton("Geoserver");		
		tb1.setToggleGroup("group");
		tb3.setToggleGroup("group");
		tb2.setToggleGroup("group");
		tb1.toggle(true);
		Listener<BaseEvent> listener = new Listener<BaseEvent>(){
			@Override
			public void handleEvent(BaseEvent be) {
				if (!tb1.isPressed() && !tb2.isPressed() && !tb3.isPressed())
					tb1.toggle(true);
			}
		};
		tb1.addListener(Events.Toggle, listener);
		tb2.addListener(Events.Toggle, listener);
		tb3.addListener(Events.Toggle, listener);

		final TextField<String> searchText = new TextField<String>();  
		final Button searchButton = new Button();
		
		searchText.setEmptyText("enter a text");
		searchText.setFieldLabel("Layer Name");
		searchText.setToolTip("Write the name of a GIS layer stored in the D4Science infrastructure.");
		searchText.setAllowBlank(true);
		searchText.addKeyListener(new KeyListener(){
			@Override
			public void componentKeyDown(ComponentEvent event) {
				super.componentKeyDown(event);
				if (event.getKeyCode()==KeyCodes.KEY_ENTER)
					searchButton.fireEvent(Events.Select);
			}
		});

		searchButton.setIcon(Images.iconSearch());
		searchButton.addSelectionListener(new SelectionListener<ButtonEvent>(){
			@Override
			public void componentSelected(ButtonEvent ce) {
				String text = searchText.getValue();
				String field = (tb1.isPressed() ? "title" : tb2.isPressed() ? "name" :"geoserverUrl");
				search(field, text);
			}
		});

		searchCancelButton = new Button();
		searchCancelButton.setIcon(Images.iconCancel());
		searchCancelButton.setEnabled(false);
		searchCancelButton.addSelectionListener(new SelectionListener<ButtonEvent>(){
			@Override
			public void componentSelected(ButtonEvent ce) {
				searchText.setValue("");
				search(null, null);
			}
		});

		ToolBar toolBar = new ToolBar();  
		toolBar.getAriaSupport().setLabel("Search");
		toolBar.add(new Label("&nbsp;Search&nbsp;&nbsp;"));
		toolBar.add(searchText);
		toolBar.add(searchButton);
		toolBar.add(new SeparatorToolItem());
		toolBar.add(searchCancelButton);
		toolBar.add(new SeparatorToolItem());		
		toolBar.add(tb1);
		toolBar.add(tb2);
		toolBar.add(tb3);

		return toolBar;
	}

	public List<LayerItem> getSelectedItems() {
		return grid.getSelectionModel().getSelectedItems();
	}

	/**
	 * 
	 */
	public void deselectAll() {
		grid.getSelectionModel().deselectAll();
	}

	/**
	 * 
	 */
	public void selectAll() {
		grid.getSelectionModel().selectAll();
	}

	public void search(String field, String text) {
		boolean cancelSearch = (text==null || text.equals(""));
		
		if (cancelSearch && !filterActive)
			return;

		// for prevent automatic reload while change filter 
		filters.setAutoReload(false);
		filters.clearFilters();

		if (!cancelSearch) {
			StringFilter filter = new StringFilter(field);
			filter.setValue(text);
			filters.addFilter(filter);
			filters.updateColumnHeadings();
		}

		ListLoader<? extends ListLoadResult<LayerItem>> loader = grid.getStore().getLoader();
		loader.load();

		// restore autoreload
		filters.setAutoReload(true);
		
		searchCancelButton.setEnabled(!cancelSearch);
		filterActive = !cancelSearch;
	}

	/**
	 * 
	 */
	public void start() {
		// button renderer
		GridCellRenderer<LayerItem> buttonRenderer = new GridCellRenderer<LayerItem>() {
			@Override
			public Object render(final LayerItem l, String property, ColumnData config,
					int rowIndex, int colIndex, ListStore<LayerItem> store, Grid<LayerItem> grid) {
				
				Image imgOpenGisViewer = new Image(ICON_OPEN_GIS_VIEWER);
				imgOpenGisViewer.setTitle("Open this Layer with GisViewer");
				imgOpenGisViewer.setStyleName("imgCursor");
				imgOpenGisViewer.addClickHandler(new ClickHandler(){
					@Override
					public void onClick(ClickEvent event) {
						layersGridListener.openLayer(l);
					}
				});
				
				return imgOpenGisViewer;  
			}
		};

		// loader
		RpcProxy<PagingLoadResult<LayerItem>> proxy = new RpcProxy<PagingLoadResult<LayerItem>>() {
			@Override
			protected void load(Object loadConfig, AsyncCallback<PagingLoadResult<LayerItem>> callback) {
				service.getLayers((BaseFilterPagingLoadConfig)loadConfig, callback);
			}
		};

		final PagingLoader<PagingLoadResult<ModelData>> loader = new BasePagingLoader<PagingLoadResult<ModelData>>(proxy) {
			/* (non-Javadoc)
			 * @see com.extjs.gxt.ui.client.data.BasePagingLoader#newLoadConfig()
			 */
			@Override
			protected Object newLoadConfig() {
				BasePagingLoadConfig config = new BaseFilterPagingLoadConfig();
				return config;
			}
		};
		loader.setRemoteSort(true);
		
		loader.addLoadListener(new LoadListener(){

			/**
			 * {@inheritDoc}
			 */
			@Override
			public void loaderLoadException(LoadEvent le) {
				Log.error("Error loading layers", le.exception);
			}

			
		});

		ListStore<LayerItem> store = new ListStore<LayerItem>(loader);
		

		final PagingToolBar pagingToolBar = new PagingToolBar(PAGE_SIZE);
		pagingToolBar.bind(loader);

		selectionModel = new CheckBoxSelectionModel<LayerItem>();
		selectionModel.setSelectionMode(SelectionMode.MULTI);

		List<ColumnConfig> columnConfigs = new ArrayList<ColumnConfig>();
		columnConfigs.add(selectionModel.getColumn());
		
		ColumnConfig columnButton = new ColumnConfig();  
		columnButton.setId("symbol");  
		columnButton.setHeader("");  
		columnButton.setWidth(25);
		columnButton.setFixed(true);
		columnButton.setSortable(false);
		columnButton.setRenderer(buttonRenderer);  
		columnConfigs.add(columnButton);  

		
		columnConfigs.add(new ColumnConfig("title", "Title", 200));
		columnConfigs.add(new ColumnConfig("name", "Name", 100));

		// for hide name
		//		ColumnConfig ccName = new ColumnConfig("name", "Name", 100);
		//		ccName.setHidden(true);		
		//		columnConfigs.add(ccName);

		columnConfigs.add(new ColumnConfig("geoserverUrl", "Geoserver", 250));

		ColumnModel cm = new ColumnModel(columnConfigs);

		filters = new GridFilters();
		StringFilter titleFilter = new StringFilter("title");
		StringFilter nameFilter = new StringFilter("name");
		filters.addFilter(titleFilter);
		filters.addFilter(nameFilter);

		grid = new Grid<LayerItem>(store, cm);
		grid.setStateId("pagingGrid");
		grid.setStateful(true);
		grid.addListener(Events.Attach, new Listener<GridEvent<LayerItem>>() {
			public void handleEvent(GridEvent<LayerItem> be) {
				loader.load(0, PAGE_SIZE);
			}
		});

		grid.addListener(Events.RowClick, new Listener<GridEvent<LayerItem>>() {
			public void handleEvent(GridEvent<LayerItem> be) {
				LayerItem layerItem = be.getModel();
				layersGridListener.clickLayer(layerItem);
			}
		});
		grid.setLoadMask(true);
		grid.setBorders(true);
		grid.setAutoExpandColumn("title");
		grid.setAutoWidth(true);
		grid.getView().setForceFit(true);
		grid.setSelectionModel(selectionModel);
		grid.addPlugin(selectionModel);
		grid.addPlugin(filters);

		ContentPanel panel = new ContentPanel();
		panel.setHeading(title);
		panel.setHeaderVisible(false);
		panel.setLayout(new FitLayout());
		add(panel);
		panel.add(grid);

		ToolBar toolBar = createToolBar();

		panel.setTopComponent(toolBar);
		panel.setBottomComponent(pagingToolBar);
		grid.getAriaSupport().setLabelledBy(panel.getId());

		this.removeAll();
		this.add(panel);
		this.layout();
	}
}
