/**
 * 
 */
package org.gcube.portlets.user.geoexplorer.client;

import org.gcube.portlets.user.geoexplorer.client.beans.LayerItem;

import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;

/**
 * @author ceras
 *
 */
public class LayerInfoPanel extends ContentPanel {
	private static final ImageResource IMAGE_PRELOADER = GeoExplorer.resources.iconPreload();

	/**
	 * 
	 */
	public LayerInfoPanel(String title) {
		super();
		this.setLayout(new FlowLayout());
		this.setHeading(".: Layer info");
		this.setBodyStyle(Constants.panelsBodyStyle);
		this.setScrollMode(Scroll.AUTO);
	}

	/**
	 * @param layerItem
	 */
	public void showLayerDetails(LayerItem layerItem) {
		String[][] fields = {{"title","Title"}, {"name","Name"}, {"layer","Full Name"}, {"geoserverUrl","Geoserver Url"}};
		String html = "<ul class='layerInfoPanel'>";
		for (String[] field: fields) {
			String value = layerItem.get(field[0]);
			html += "<li class='layerInfoPanel-field'>" + field[1] +
					"	<ul>" +
					"		<li class='layerInfoPanel-item-value'><nobr>" + value + "</nobr></li>" +
					"	</ul>" +
					"</li>";
			//&nbsp; <b>" + field[1] + ":</b><br>&nbsp;&nbsp;&nbsp;&nbsp;<nobr>"+value+"</nobr><br><br>";
			//html += "&nbsp; <b>" + field[1] + ":</b><br>&nbsp;&nbsp;&nbsp;&nbsp;<nobr>"+value+"</nobr><br><br>";
		}

		html += "<li class='layerInfoPanel-field'>Layer Preview</li>";	
		html += "</ul>";

		String urlImage = getUrlPreviewMap(layerItem);
		final Image imgPreview = new Image(urlImage);
		imgPreview.setStyleName("layerInfoPanel-imgPreview");
		imgPreview.setVisible(false);

		final Image imgPreloader = new Image(IMAGE_PRELOADER);
		imgPreloader.setStyleName("layerInfoPanel-imgPreload");

		this.removeAll();
		this.add(new Html(html));
		this.add(imgPreloader);
		this.add(imgPreview);
		this.layout();

		imgPreview.addLoadHandler(new LoadHandler(){
			public void onLoad(LoadEvent event) {
				remove(imgPreloader);
				imgPreview.setVisible(true);
				layout();
			}
		});

		//imgCloseLayerButton.setResource(ICON_CLOSE_LAYER);
		
//		html += "<li class='layerInfoPanel-field'>Layer Preview" +
//				"	<ul>" +
//				"		<li class='layerInfoPanel-item-value'><img src='" + getUrlPreviewMap(layerItem) + "' /></li>" +
//				"	</ul>" +
//				"</li>";	
		
	}

	/**
	 * @param layerItem
	 * @return
	 */
	private String getUrlPreviewMap(LayerItem layerItem) {
		//<serverName>/<servletName>?geoserver=<geoserverUrl>&layer=<layerCompleteName>
		String url = GWT.getModuleBaseURL() + "MapPreviewGenerator?"
				+ "geoserver=" + layerItem.getGeoserverUrl()+ "/wms/"
				+ "&layer=" + layerItem.getLayer();
		return url;
	}
}
