/**
 * 
 */
package org.gcube.portlets.user.gcubegeoexplorer.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.geoexplorer.client.Constants;
import org.gcube.portlets.user.geoexplorer.server.GeoExplorerServiceImpl;
import org.gcube.portlets.user.geoexplorer.server.GeoExplorerServiceParameters;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class GCubeGeoExplorerServletImpl  extends GeoExplorerServiceImpl {

	private static final long serialVersionUID = 804152795418658243L;

	public static final String USERNAME_ATTRIBUTE = "username";
	public static final String GEOSERVER_RESOURCE_NAME = "GeoServer";
	public static final String GEONETWORK_RESOURCE_NAME = "GeoNetwork";
	public static final String GEOCALLER_ATTRIBUTE_NAME = "GEOCALLER";
	private static final String WORKSPACES_PROPERTY_NAME = "workspaces";
	public static final long CACHE_REFRESH_TIME = 10*60*1000;


	public static GCUBELog log = new GCUBELog(GCubeGeoExplorerServletImpl.class);

	protected Map<GCUBEScope, GeoExplorerServiceParameters> parametersCache = new HashMap<GCUBEScope, GeoExplorerServiceParameters>();
	protected Logger logger = Logger.getLogger(GCubeGeoExplorerServletImpl.class);
	protected Timer timer;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void init() throws ServletException {
		super.init();

		timer = new Timer(true);
		timer.schedule(new TimerTask() {
			@Override
			public void run() {
				refreshParametersCache();
			}
		}, 0, CACHE_REFRESH_TIME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void destroy() {
		super.destroy();
		timer.cancel();
	}

	protected ASLSession getASLSession(HttpSession httpSession)
	{
		String sessionID = httpSession.getId();
		String user = (String) httpSession.getAttribute(USERNAME_ATTRIBUTE);

		if (user == null) {

			logger.info("GCubeGeoExplorerServletImpl STARTING IN TEST MODE - NO USER FOUND");

			//for test only
			user = "test.user";
			httpSession.setAttribute(USERNAME_ATTRIBUTE, user);
			ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);
			session.setScope(Constants.defaultScope);
			//session.setScope("/gcube/devsec/devVRE");

			return session;
		} else logger.trace("user found in session "+user);
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}


	protected ServerParameters getParameters(GCUBEScope scope, boolean isGeoserver) throws Exception
	{
		String resourceName = (isGeoserver ? GEOSERVER_RESOURCE_NAME : GEONETWORK_RESOURCE_NAME); 
				
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBERuntimeResourceQuery rtrQuery = client.getQuery(GCUBERuntimeResourceQuery.class);
		rtrQuery.addAtomicConditions(new AtomicCondition("/Profile/Name",resourceName));

		List<GCUBERuntimeResource> rtrs = client.execute(rtrQuery, scope);

		if (rtrs.size()==0) throw new Exception("Resource "+resourceName+" not found");

		GCUBERuntimeResource rtr = rtrs.get(0);

		if (rtr.getAccessPoints().size()==0) throw new Exception("Accesspoint in resource "+resourceName+" not found");

		ServerParameters parameters = new ServerParameters();

		AccessPoint ap = rtr.getAccessPoints().get(0);
		parameters.setUrl(ap.getEndpoint());
		parameters.setUser(ap.getUsername()); //username
		parameters.setPassword(ap.getPassword()); //password
		
		if (isGeoserver)
			parameters.setWorkspaces(ap.getProperty(WORKSPACES_PROPERTY_NAME));

		return parameters;
	}

	protected GeoExplorerServiceParameters retrieveGisParameters(GCUBEScope scope) throws Exception
	{
		GeoExplorerServiceParameters gisViewerServiceParameters = new GeoExplorerServiceParameters();

		try {
			ServerParameters geoServerParameters = getParameters(scope, true);
			gisViewerServiceParameters.setGeoServerUrl(geoServerParameters.getUrl());
			gisViewerServiceParameters.setGeoServerUser(geoServerParameters.getUser());
			gisViewerServiceParameters.setGeoServerPwd(geoServerParameters.getPassword());
			gisViewerServiceParameters.setWorkspaces(geoServerParameters.getWorkspaces());
		} catch (Exception e)
		{
			logger.error("Error retrieving the GeoServer parameters", e);
			throw new Exception("Error retrieving the GeoServer parameters", e);
		}

		try {
			ServerParameters geoNetworkParameters = getParameters(scope, false);
			gisViewerServiceParameters.setGeoNetworkUrl(geoNetworkParameters.getUrl());
			gisViewerServiceParameters.setGeoNetworkUser(geoNetworkParameters.getUser());
			gisViewerServiceParameters.setGeoNetworkPwd(geoNetworkParameters.getPassword());
		} catch (Exception e)
		{
			logger.error("Error retrieving the GeoNetwork parameters", e);
			throw new Exception("Error retrieving the GeoNetwork parameters", e);
		}

		logger.trace("retrieved parameters: "+gisViewerServiceParameters);

		return gisViewerServiceParameters;		
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected GeoExplorerServiceParameters getParameters(HttpSession httpSession) throws Exception {
		//httpSession = this.getThreadLocalRequest().getSession();
		ASLSession session = getASLSession(httpSession);
		GCUBEScope scope = session.getScope();

		GeoExplorerServiceParameters parameters = parametersCache.get(scope);

		if (parameters == null) {
			parameters = retrieveGisParameters(scope);
			parametersCache.put(scope, parameters);
		}

		return parameters;
	}

	protected void refreshParametersCache()
	{
		for (GCUBEScope scope:parametersCache.keySet()) {
			try{
				GeoExplorerServiceParameters parameters = retrieveGisParameters(scope);
				parametersCache.put(scope, parameters);
			} catch (Exception e) {
				logger.warn("An error occured retrieving gis parameters for scope "+scope, e);
			}
		}
	}

//	protected GeoCaller getGeoCaller(HttpSession httpSession) throws Exception
//	{
//		ASLSession session = getASLSession(httpSession);
//		GeoCaller geoCaller = (GeoCaller) session.getAttribute(GEOCALLER_ATTRIBUTE_NAME);
//
//		if (geoCaller==null) {
//			try {
//				GeoExplorerServiceParameters parameters = getParameters(httpSession);
//				String geoserverUrl = parameters.getGeoServerUrl();
//				String geonetworkUrl = parameters.getGeoNetworkUrl();
//				String gnUser = parameters.getGeoNetworkUser();
//				String gnPwd = parameters.getGeoNetworkPwd();
//				String gsUser = parameters.getGeoServerUser();
//				String gsPwd = parameters.getGeoServerPwd();
//
//				geoCaller = new GeoCaller(geonetworkUrl, gnUser, gnPwd, geoserverUrl, gsUser, gsPwd, researchMethod);
//
//				session.setAttribute(GEOCALLER_ATTRIBUTE_NAME, geoCaller);
//
//			} catch (Exception e) {
//				throw new Exception("Error initializing the GeoCaller", e);
//			}
//		}
//
//		return geoCaller;
//	}

	
	
//	public static void main(String[] args) throws MalformedScopeExpressionException, Exception
//	{
//		GCubeGeoExplorerServletImpl impl = new GCubeGeoExplorerServletImpl();
//		GeoExplorerServiceParameters parameters = impl.retrieveGisParameters(GCUBEScope.getScope("/gcube/devsec/deVRE"));
//		System.out.println(parameters);
//
//	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.geoexplorer.server.GeoExplorerServiceImpl#printLog(java.lang.String)
	 */
	@Override
	protected void printLog(LOGTYPE logType, String message) {
		if (Constants.localLog) {
			if (logType==LOGTYPE.INFO)
				System.out.println("[INFO] "+message);
			else if (logType==LOGTYPE.ERROR)
				System.out.println("[ERROR] "+message);
			else
				System.out.println("[LOG] "+message);
		} else {
			if (logType==LOGTYPE.INFO)
				logger.info(message);
			else if (logType==LOGTYPE.ERROR)
				logger.error(message);
			else
				logger.debug(message);
		}
	}
	
}
