package org.gcube.portlets.widgtes.wsthreddssync.client;

import org.gcube.portal.wssynclibrary.shared.thredds.ThSyncStatus;
import org.gcube.portlets.widgtes.wsthreddssync.client.event.PerformDoSyncEvent;
import org.gcube.portlets.widgtes.wsthreddssync.client.event.PerformDoSyncEventHandler;
import org.gcube.portlets.widgtes.wsthreddssync.client.event.ShowMonitorSyncStatusEvent;
import org.gcube.portlets.widgtes.wsthreddssync.client.event.ShowMonitorSyncStatusEventHandler;
import org.gcube.portlets.widgtes.wsthreddssync.client.rpc.ThreddsWorkspaceSyncServiceAsync;
import org.gcube.portlets.widgtes.wsthreddssync.client.view.LoaderIcon;
import org.gcube.portlets.widgtes.wsthreddssync.client.view.WsThreddsWidgetViewManager;
import org.gcube.portlets.widgtes.wsthreddssync.client.view.binder.MonitorFolderSyncStatusView;
import org.gcube.portlets.widgtes.wsthreddssync.shared.WsFolder;
import org.gcube.portlets.widgtes.wsthreddssync.shared.WsThreddsSynchFolderConfiguration;
import org.gcube.portlets.widgtes.wsthreddssync.shared.WsThreddsSynchFolderDescriptor;

import com.github.gwtbootstrap.client.ui.Modal;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;


// TODO: Auto-generated Javadoc
/**
 * The Class WsThreddsWidget.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Feb 14, 2018
 */
public class WsThreddsWidget {

	/** The ws thredds sync service. */
	public static final ThreddsWorkspaceSyncServiceAsync wsThreddsSyncService = ThreddsWorkspaceSyncServiceAsync.Util.getInstance();
	
	/** The Constant eventBus. */
	public final static HandlerManager eventBus = new HandlerManager(null);
	
	private WsThreddsWidgetViewManager viewManager = new WsThreddsWidgetViewManager();

	/**
	 * This is the entry point method.
	 */
	public WsThreddsWidget() {
		bindEvents();

	}

	/**
	 * Bind events.
	 */
	private void bindEvents() {
		
		eventBus.addHandler(PerformDoSyncEvent.TYPE, new PerformDoSyncEventHandler() {
			
			@Override
			public void onPerformDoSync(PerformDoSyncEvent performDoSyncEvent) {
				
				if(performDoSyncEvent.getFolder()!=null)
				
					performFolderSync(performDoSyncEvent.getFolder(), performDoSyncEvent.getConf());
			}
		});
		
		eventBus.addHandler(ShowMonitorSyncStatusEvent.TYPE, new ShowMonitorSyncStatusEventHandler() {
			
			@Override
			public void onShowMonitorSyncStatus(ShowMonitorSyncStatusEvent showSyncStatusEvent) {
				
				if(showSyncStatusEvent.getFolder()!=null)
				
					viewManager.showMonitorSyncToFolder(showSyncStatusEvent.getFolder());
				
			}
		});
			
	}


	/**
	 * Show sync folder info.
	 *
	 * @param folder the folder
	 * @throws Exception the exception
	 */
	public void showSyncFolderInfo(final WsFolder folder) throws Exception {
		
		if(folder==null || folder.getFolderId()==null)
			throw new Exception("Invalid parameter folder null");
		
		
		MonitorFolderSyncStatusView monitor = viewManager.getMonitor(folder);
		
		//SHOWING CURRENT ACTIVE MONITOR
		if(monitor!=null) {
			viewManager.showMonitorSyncToFolder(folder);
			return;
		}
		
		
		GWT.log("Performing isItemSynched: "+folder.getFolderId());
		final Modal box = new Modal(true);
		box.setTitle("Checking configurations...");
		LoaderIcon loader = new LoaderIcon("Checking folder configurations...");
		box.add(loader);
		
		WsThreddsWidget.wsThreddsSyncService.isItemSynched(folder.getFolderId(), new AsyncCallback<WsThreddsSynchFolderDescriptor>() {
			
			@Override
			public void onSuccess(WsThreddsSynchFolderDescriptor result) {
				box.hide();
				//GWT.log("WsThreddsSynchFolderDescriptor result: "+result);
				viewManager.showThreddsFolderInfo(folder, result);
				
			}
			
			@Override
			public void onFailure(Throwable caught) {
				viewManager.cancelMonitor(folder);
				box.hide();
				// TODO Auto-generated method stub
				Window.alert(caught.getMessage());
			}
		});
		
		box.show();

	}
	

	/**
	 * Perform folder sync.
	 *
	 * @param folder the folder
	 * @param config the config
	 */
	private void performFolderSync(final WsFolder folder, WsThreddsSynchFolderConfiguration config) {
		
		GWT.log("Performing doSyncFolder on: "+folder);
		final Modal box = new Modal(true);
		box.setTitle("Starting synchronization...");
		LoaderIcon loader = new LoaderIcon("Inizializiting synchronization to the folder: "+folder.getFoderName());
		box.add(loader);
		
		wsThreddsSyncService.doSyncFolder(folder.getFolderId(), config, new AsyncCallback<ThSyncStatus>() {

			@Override
			public void onFailure(Throwable caught) {
				Window.alert(caught.getMessage());
				viewManager.cancelMonitor(folder);
				
			}

			@Override
			public void onSuccess(ThSyncStatus result) {
				box.hide();
				GWT.log("Updating sync status: "+result);
				viewManager.showMonitorSyncToFolder(folder);
				
			}
		});
		box.show();
	}
}
