/**
 *
 */
package org.gcube.portlets.widgets.wsthreddssync.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

//import org.gcube.common.homelibrary.home.HomeLibrary;
//import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
//import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
//import org.gcube.common.homelibrary.home.workspace.Workspace;
//import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehubwrapper.server.StorageHubWrapper;
import org.gcube.common.storagehubwrapper.server.tohl.Workspace;
import org.gcube.portlets.widgets.wsthreddssync.shared.GatewayRolesThredds;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
//import org.gcube.portlets.user.workspace.server.util.WsUtil;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.service.UserLocalServiceUtil;

/**
 * The Class WsUtil.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Nov 25, 2016
 */
public class WsUtil {
	
	

	/** The logger. */
	private static Logger logger = LoggerFactory.getLogger(WsUtil.class);


	/**
	 * Checks if is within portal.
	 *
	 * @return true if you're running into the portal, false if in development
	 */
	public static boolean isWithinPortal() {
		try {
			UserLocalServiceUtil.getService();
			return true;
		}
		catch (Exception ex) {
			logger.trace("Development Mode ON");
			return false;
		}
	}


	/**
	 * Checks if is session expired.
	 *
	 * @param httpServletRequest the http servlet request
	 * @return true, if is session expired
	 * @throws Exception the exception
	 */
	public static boolean isSessionExpired(HttpServletRequest httpServletRequest) throws Exception {
		logger.trace("workspace session validating...");
		return PortalContext.getConfiguration().getCurrentUser(httpServletRequest)==null;
	}

	/**
	 * Gets the workspace from storage hub.
	 *
	 * @param httpServletRequest the http servlet request
	 * @return the workspace from storage hub
	 * @throws Exception the exception
	 */
	public Workspace getWorkspaceFromStorageHub(HttpServletRequest httpServletRequest) throws Exception {
		logger.trace("Get Workspace");
//		String scope = PortalContext.getConfiguration().getCurrentScope(httpServletRequest);

		GCubeUser user = null;
		
		try {
			String scope = PortalContext.getConfiguration().getCurrentScope(httpServletRequest);
			user = PortalContext.getConfiguration().getCurrentUser(httpServletRequest);
			if (user == null || user.getUsername().isEmpty())
				throw new Exception("Session expired");
			
			ScopeProvider.instance.set(scope);
			logger.trace("Scope provider instancied at: "+scope);
			
			logger.debug("Getting " + StorageHubWrapper.class.getSimpleName() + " for user: " + user.getUsername()
					+ " by using the scope: " + scope);

			String token =  PortalContext.getConfiguration().getCurrentUserToken(scope, user.getUsername());
			StorageHubWrapper shWrapper = new StorageHubWrapper(scope, token, false, false, true);
			return shWrapper.getWorkspace();
		} catch (Exception e) {
			logger.error("Error on getting the Workspace via SHUB wrapper", e);
			throw new Exception("Error on gettig the Workspace for userId: " + user);
		}
	}

	/**
	 * Gets the list of Scopes (Root-VO, VOs and VREs) for user and the Thredds roles that user has in them.
	 *
	 * @param user the user
	 * @return the VREs and Thredds roles for a given user
	 */
	public static Map<String, GatewayRolesThredds> getScopesWithThreddsRolesForUser(GCubeUser user){
		logger.info("called getScopesThreddsRolesForUser user: "+user+", in all contexts");
		
		GroupManager groupManager = new LiferayGroupManager();
		Map<String, GatewayRolesThredds> mapRoleByGroupSingleVre = new HashMap<String, GatewayRolesThredds>();
		try {
			
			//Retrieving the list of VOs and VREs
			List<GCubeGroup> listOfGroups = groupManager.listGroupsByUser(user.getUserId());
			//adding also the ROOT-VO
			listOfGroups.add(groupManager.getRootVO());
			for (GCubeGroup gCubeGroup : listOfGroups) {
				GatewayRolesThredds threddsRole = getThreddsRoleFor(user, gCubeGroup);
				if(threddsRole != null) {
					String toFullScope = groupManager.getInfrastructureScope(gCubeGroup.getGroupId());
					mapRoleByGroupSingleVre.put(toFullScope, threddsRole);
				}
			}
			
			logger.info("For user: "+user+", returning Map (VRE, ThreddsRoles)  " + mapRoleByGroupSingleVre);
			return mapRoleByGroupSingleVre;
		}catch (UserManagementSystemException | UserRetrievalFault | GroupRetrievalFault e) {
			logger.error("An error occurred during geThreddsVreRolesForUser: "+user, e);
			return null;
		} 
	}
	

	/**
	 * Gets the (highest) thredds role for the user in the scope
	 *
	 * @param user the user
	 * @param scope the vre
	 * @return the thredds role for
	 */
	public static GatewayRolesThredds getThreddsRoleFor(GCubeUser user, GCubeGroup scope){
		if(user==null || scope==null) {
			logger.warn("called getThreddsRoleFor with invalid parameter user: "+user+", in the scope: "+scope, ", returning null");
			return null;
		}
			
		logger.info("called getThreddsRoleFor user: "+user.getUsername()+", in the scope: "+scope.getGroupName());
		try {
			RoleManager roleManager = new LiferayRoleManager();
			List<GCubeRole> roles = roleManager.listRolesByUserAndGroup(user.getUserId(), scope.getGroupId());
			List<GatewayRolesThredds> threddsRoles = new ArrayList<GatewayRolesThredds>();
			for (GCubeRole gCubeRole : roles) {
				if(gCubeRole.getRoleName().equalsIgnoreCase(GatewayRolesThredds.DATA_MANAGER.getRoleName())){
					threddsRoles.add(GatewayRolesThredds.DATA_MANAGER);
				}
				if(gCubeRole.getRoleName().equalsIgnoreCase(GatewayRolesThredds.DATA_EDITOR.getRoleName())){
					threddsRoles.add(GatewayRolesThredds.DATA_EDITOR);
				}
			}
			
			logger.info("For user: "+user.getUsername()+" in the scope: "+scope.getGroupName()+" read the role/s: " + threddsRoles);
			
			GatewayRolesThredds toReturn = null;
			if (threddsRoles.contains(GatewayRolesThredds.DATA_MANAGER))
				toReturn = GatewayRolesThredds.DATA_MANAGER;
			else if (threddsRoles.contains(GatewayRolesThredds.DATA_EDITOR))
				toReturn = GatewayRolesThredds.DATA_EDITOR;
			
			logger.info("returning highest role: " + toReturn);
			return toReturn;
		}catch (UserRetrievalFault | GroupRetrievalFault e) {
			logger.error("An error occurred during getVreRoleForUser: "+user, e);
			return null;
		}
	}
	

}
