package org.gcube.datacatalogue.grsf_manage_widget.client.view.subwidgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.gcube.datacatalogue.common.enums.Product_Type;
import org.gcube.datacatalogue.grsf_manage_widget.shared.ConnectedBean;
import org.gcube.datacatalogue.grsf_manage_widget.shared.ManageProductBean;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.Paragraph;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Float;
import com.google.gwt.dom.client.Style.FontWeight;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ConnectToWidget extends Composite{

	private static ConnectToWidgetUiBinder uiBinder = GWT
			.create(ConnectToWidgetUiBinder.class);

	interface ConnectToWidgetUiBinder extends UiBinder<Widget, ConnectToWidget> {
	}

	@UiField
	VerticalPanel connectPanel;

	@UiField
	Button suggestRecord;

	//private GRSFManageWidgetServiceAsync service;
	private List<Tuple> connectList = new ArrayList<Tuple>(0);

	private List<ConnectedBean> connectedRecords = null;

	public ConnectToWidget(final ManageProductBean bean/*, GRSFManageWidgetServiceAsync service*/) {
		initWidget(uiBinder.createAndBindUi(this));

		// get already connected beans, if any
		connectedRecords = bean.getConnectTo();

		if(connectedRecords != null){
			connectPanel.add(new HTML("<hr style=\"width:100%;\"/>"));
			for (ConnectedBean connected : connectedRecords) {
				Widget widget = buildWidgetForConnectedRecords(connected);
				connectPanel.add(widget);
				connectPanel.add(new HTML("<hr style=\"width:100%;\"/>"));
			}

		}
		//this.service = service;
		String acceptedDomain = bean.getGrsfDomain().equalsIgnoreCase(Product_Type.STOCK.getOrigName()) ? Product_Type.FISHERY.getOrigName()  : Product_Type.STOCK.getOrigName(); // inverted
		suggestRecord.setTitle("Connect this " + bean.getGrsfDomain() + " record to a " + acceptedDomain + " record ");
		suggestRecord.setIcon(IconType.PLUS_SIGN);
		suggestRecord.getElement().getStyle().setFloat(Float.RIGHT);

		// add handler
		suggestRecord.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent arg0) {

				ConnectedBean cb = new ConnectedBean();
				cb.setExtra(true);
				cb.setSourceDomain(bean.getGrsfDomain());
				Tuple t = buildWidgetConnect(cb);
				connectList.add(t);
				connectPanel.add(t.getW());

			}
		});

	}

	/**
	 * 
	 * @param similarGRSFRecord
	 * @return
	 */
	public static Widget buildWidgetForConnectedRecords(final ConnectedBean connected){

		HorizontalPanel hp = new HorizontalPanel();
		hp.setWidth("95%");
		VerticalPanel leftPanel = new VerticalPanel();
		leftPanel.setWidth("80%");
		leftPanel.getElement().getStyle().setMarginLeft(20, Unit.PX);
		Paragraph name = new Paragraph("Record name: " + (connected.getDestShortName() != null? connected.getDestShortName() : "Unavailable"));
		leftPanel.add(name);
		Paragraph semanticIdentifier = new Paragraph("Semantic Identifier: " + 
				connected.getDestSemanticIdentifier());
		leftPanel.add(semanticIdentifier);
		Paragraph identifier = new Paragraph("Record UUID: " + 
				connected.getDestKnowledgeBaseId());
		leftPanel.add(identifier);

		Anchor view = new Anchor();
		view.setHref(connected.getUrl());
		view.setText("View"); 
		view.setTitle("Click to view the similar record");
		view.setTarget("_blank");
		view.getElement().getStyle().setFontWeight(FontWeight.BOLD);
		leftPanel.add(view);

		VerticalPanel rightPanel = new VerticalPanel();
		rightPanel.setWidth("20%");

		final CheckBox removeExtra = new CheckBox("Remove");
		removeExtra.setTitle("Remove this record among the similar ones");
		removeExtra.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent arg0) {
				connected.setToBeKept(!removeExtra.getValue());
			}
		});

		rightPanel.getElement().getStyle().setFloat(Float.RIGHT);
		rightPanel.add(removeExtra);
		hp.add(leftPanel);
		hp.add(rightPanel);
		hp.getElement().getStyle().setPadding(10, Unit.PX);
		hp.getElement().getStyle().setMarginBottom(10, Unit.PX);
		return hp;
	}

	/**
	 * Builds up a widget for connecting records.
	 * @param w the widget
	 * @param cb the connectBean.
	 */
	private Tuple buildWidgetConnect(final ConnectedBean cb){

		VerticalPanel main = new VerticalPanel();
		main.setWidth("95%");
		HorizontalPanel hp = new HorizontalPanel();
		hp.setWidth("100%");

		VerticalPanel vpLeft = new VerticalPanel();
		vpLeft.getElement().getStyle().setMarginLeft(15, Unit.PX);
		vpLeft.setWidth("80%");
		Paragraph semanticIdentifier = new Paragraph("Identifier (UUID):");
		final TextBox box = new TextBox();
		box.setId("identifier-text");
		box.addKeyPressHandler(new KeyPressHandler() {

			@Override
			public void onKeyPress(KeyPressEvent event) {

				String currentText = box.getText().trim();
				GWT.log("Text changed to " + currentText);
				cb.setDestKnowledgeBaseId(currentText);

			}
		});
		box.addChangeHandler(new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {

				String currentText = box.getText().trim();
				GWT.log("Text changed to " + currentText);
				cb.setDestKnowledgeBaseId(currentText);

			}
		});
		box.setWidth("512px");
		box.setPlaceholder("Insert the Identifier (UUID) of the record to connect");

		vpLeft.add(semanticIdentifier);
		vpLeft.add(box);

		VerticalPanel vpRight = new VerticalPanel();
		vpRight.setWidth("20%");

		Button removeExtra = new Button();
		removeExtra.setIcon(IconType.MINUS);
		removeExtra.setTitle("Remove this connection");
		removeExtra.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent arg0) {

				// remove this object from the pairs list
				Iterator<Tuple> iterator = connectList.iterator();
				while (iterator.hasNext()) {
					Tuple pair = (Tuple) iterator
							.next();
					if(pair.getO().equals(cb)){
						pair.getW().removeFromParent();
						iterator.remove();
					}
				}
			}
		});
		vpRight.getElement().getStyle().setFloat(Float.RIGHT);
		vpRight.add(removeExtra);
		hp.add(vpLeft);
		hp.add(vpRight);
		HTML separator = new HTML("<hr style=\"width:100%;\"/>");
		connectPanel.add(separator);
		main.add(hp);
		main.add(separator);
		return new Tuple(cb, main, box);
	}

	/**
	 * Get the list of records to connect with this one
	 * @return
	 */
	public List<ConnectedBean> getConnectList() {

		if(connectedRecords == null)
			connectedRecords = new ArrayList<ConnectedBean>(0);

		for (Tuple p : connectList) {
			String suggestedIdentifier = ((ConnectedBean)p.getO()).getDestKnowledgeBaseId();
			if(suggestedIdentifier == null || suggestedIdentifier.isEmpty())
				continue;
			else
				connectedRecords.add((ConnectedBean) p.getO());
		}

		return connectedRecords;
	}

}
