package org.gcube.portlets.widgets.dataminermanagerwidget.server;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorCategory;


/**
 * 
 * @author Giancarlo Panichi
 * email: <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class DescriptionRepository {

	static List<OperatorCategory> categories;
	static List<Operator> operators;

	private static void initCategories() {
		if (categories==null) {
			categories = new ArrayList<OperatorCategory>();
			categories.add(new OperatorCategory(
					"DISTRIBUTIONS", 
					"Distributions description", 
					"This category includes probability distributions, classifications, matching or distance measurements etc.",
					true));
			categories.add(new OperatorCategory(
					"MODELS", 
					"Models description", 
					"This category includes models to be trained, e.g. neural networks, species envelopes, support vector machines etc.. The result will be typically a binary file.",
					false));
			categories.add(new OperatorCategory(
					"EVALUATORS", 
					"A set of procedures for measuring the quality of a model", 
					"This category represent a set of procedures for measuring the quality of a model.",
					false));
		}
	}

	private static void initOperators() {
		if (operators==null) {
			operators = new ArrayList<Operator>();
			operators.add(new Operator(
					"AQUAMAPS_NATIVE_2050", 
					"Aquamaps Native for 2050 scenario", 
					"Aquamaps Native for 2050 scenario.", null, true));
			operators.add(new Operator(
					"REMOTE_AQUAMAPS_SUITABLE_2050", 
					"Aquamaps Suitable for 2050 scenario", 
					"Aquamaps Suitable for 2050 scenario.", null, true));
			operators.add(new Operator(
					"AQUAMAPS_SUITABLE_NEURALNETWORK", 
					"Aquamaps Suitable Distribution using a feed-Forward Neural Network", 
					"Aquamaps Suitable Distribution using a feed-Forward Neural Network.", null, true));
			operators.add(new Operator(
					"REMOTE_AQUAMAPS_NATIVE", 
					"Aquamaps Native habitat generated by invoking Rainy Cloud", 
					"Aquamaps Native habitat generated by invoking Rainy Cloud.", null, true));
			operators.add(new Operator(
					"AQUAMAPS_NEURAL_NETWORK_NS", 
					"Aquamaps Suitable Distribution using a Feed-Forward Neural Network provided by Neurosolutions", 
					"Aquamaps Suitable Distribution using a Feed-Forward Neural Network provided by Neurosolutions (<a href='http://www.neurosolutions.com/' target='blank'>http://www.neurosolutions.com</a>).", null, true));
			operators.add(new Operator(
					"REMOTE_AQUAMAPS_NATIVE_2050", 
					"Aquamaps Native 2050 habitat generated by invoking Rainy Cloud", 
					"Aquamaps Native 2050 habitat generated by invoking Rainy Cloud.", null, true));
			operators.add(new Operator(
					"REMOTE_AQUAMAPS_SUITABLE", 
					"Aquamaps Suitable habitat generated by invoking Rainy Cloud", 
					"Aquamaps Suitable habitat generated by invoking Rainy Cloud.", null, true));
			operators.add(new Operator(
					"AQUAMAPS_SUITABLE", 
					"Aquamaps Suitable habitat production", 
					"Aquamaps Suitable habitat production.", null, true));
			operators.add(new Operator(
					"AQUAMAPS_NATIVE_NEURALNETWORK", 
					"Aquamaps Native Distribution using a Feed-Forward Neural Network", 
					"Aquamaps Native Distribution using a Feed-Forward Neural Network.", null, true));
			operators.add(new Operator(					
					"AQUAMAPS_NATIVE", 
					"Aquamaps Native habitat production", 
					"Aquamaps Native habitat production.", null, true));
			operators.add(new Operator(
					"AQUAMAPS_SUITABLE_2050", 
					"Aquamaps Suitable for 2050 scenario", 
					"Aquamaps Suitable for 2050 scenario.", null, true));
			operators.add(new Operator(
					"AQUAMAPSNN", 
					"Feed-Forward Neural Network for usage in Aquamaps generations", 
					"Feed-Forward Neural Network for usage in Aquamaps generations.", null, true));
			operators.add(new Operator(
					"AQUAMAPSNNNS", 
					"Feed-Forward Neural Network by Neurosolutions for usage in Aquamaps generations", 
					"Feed-Forward Neural Network by Neurosolutions (<a href='http://www.neurosolutions.com/' target='blank'>http://www.neurosolutions.com</a>) for usage in Aquamaps generations.", null, true));
			operators.add(new Operator(
					"HSPEN", 
					"Hspen model by Aquamaps", 
					"Hspen model by Aquamaps.", null, true));
			operators.add(new Operator(
					"QUALITY_ANALYSIS", 
					"", 
					".", null));
			operators.add(new Operator(
					"DISCREPANCY_ANALYSIS", 
					"", 
					".", null));
		}
	}

	public static OperatorCategory getOperatorCategory(OperatorCategory operatorCategory) {
		initCategories();
		for (OperatorCategory cat : categories)
			if (operatorCategory.getId().contentEquals(cat.getId()))
				return cat;
		return null;
	}

	public static Operator getOperator(Operator operator) {
		initOperators();
		for (Operator op : operators)
			if (operator.getId().contentEquals(op.getId()))
				return op;
		return null;
	}
}

