package org.gcube.portlets.widgets.ckan2zenodopublisher.client.view;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.widgets.ckan2zenodopublisher.client.ui.publishfile.PublishFileView;
import org.gcube.portlets.widgets.ckan2zenodopublisher.client.ui.publishfile.PublishFilesFormView;
import org.gcube.portlets.widgets.ckan2zenodopublisher.shared.wrapped.ZenodoFile;

import com.google.gwt.user.client.ui.Composite;

public class PublishFileViewManager {

	private List<ZenodoFile> listFiles;
	private PublishFilesFormView publishFileFormView;
	private int tabIndex;

	public PublishFileViewManager(List<ZenodoFile> listFiles, int tabIndex) {
		this.listFiles = listFiles;
		this.publishFileFormView = new PublishFilesFormView(tabIndex);
		addFilesToView();
	}

	private void addFilesToView() {

		if (listFiles != null) {
			for (ZenodoFile file : listFiles) {
				PublishFileView pfv = addFileForPublishing(file);
				publishFileFormView.addFile(pfv);
			}
		}
	}
	
	private PublishFileView addFileForPublishing(ZenodoFile file) {
		PublishFileView pv = new PublishFileView(file);
		pv.getField_file_name().setValue(file.getFilename());
		pv.getSwitchButton().setValue(true);
		
		if(file.getIsAlreadyPublished()) {
			pv.hideSwitchButton(true, "File already published on Zenodo");
		}
		return pv;
	}
	
	public Composite getView(){
		return publishFileFormView;
	}
	
	
	/**
	 * Gets the selected file to zenodo publishing.
	 *
	 * @return the selected file to zenodo publishing
	 */
	public List<ZenodoFile> getSelectedFileToZenodoPublishing(){
		
		List<PublishFileView> listOfPublFilesFormView = publishFileFormView.getListOfPublishingFileView();
		
		 List<ZenodoFile> lisFileToPublish = new ArrayList<ZenodoFile>();
		for (PublishFileView publishFileView : listOfPublFilesFormView) {
			if(publishFileView.isToPublish()) {
				lisFileToPublish.add(publishFileView.getFile());
			}
		}
		
		return lisFileToPublish;
	}

}
