package org.gcube.portlets.widgets.ckan2zenodopublisher.client.ui.publishfile;

import java.util.ArrayList;
import java.util.List;

import com.github.gwtbootstrap.client.ui.Fieldset;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

/**
 * The Class PublishFilesFormView.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 * Dec 17, 2019
 */
public class PublishFilesFormView extends Composite {

	private static PublishFilesFormViewUiBinder uiBinder = GWT.create(PublishFilesFormViewUiBinder.class);
	
	@UiField
	Fieldset field_form_files;
	
//	@UiField
//	Pager pager;
	
	private List<PublishFileView> lstPFV = new ArrayList<PublishFileView>();

	/**
	 * The Interface PublishFilesFormViewUiBinder.
	 *
	 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
	 * 
	 * Dec 17, 2019
	 */
	interface PublishFilesFormViewUiBinder extends UiBinder<Widget, PublishFilesFormView> {
	}

	/**
	 * Instantiates a new publish files form view.
	 * @param tabIndex 
	 */
	public PublishFilesFormView(int tabIndex) {
		initWidget(uiBinder.createAndBindUi(this));
		
	}

	/**
	 * Adds the file.
	 *
	 * @param fileVP the file VP
	 */
	public void addFile(PublishFileView fileVP) {
		lstPFV.add(fileVP);
		field_form_files.add(fileVP);
	}
	
	
	/**
	 * Gets the list of publishing file view.
	 *
	 * @return the list of publishing file view
	 */
	public List<PublishFileView> getListOfPublishingFileView(){
		return lstPFV;
	}

}
