package org.gcube.portlets.widgets.fileupload.server;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import org.gcube.portlets.widgets.fileupload.client.UploadProgressService;
import org.gcube.portlets.widgets.fileupload.shared.event.*;
import org.gcube.portlets.widgets.fileupload.shared.dto.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("serial")
public final class UploadProgressServlet extends RemoteServiceServlet implements UploadProgressService {

	private static final int EVENT_WAIT = 30 * 1000;
	private static final Logger _log = LoggerFactory.getLogger(UploadProgressServlet.class);
	private String uploadDirectory;

	@Override
	public void init() throws ServletException {
		String dir = this.getServletContext().getRealPath("/");
		System.out.println("UpDir: " + dir);
		uploadDirectory = dir ;
	}

	@Override
	public void initialise() {
		getThreadLocalRequest().getSession(true);
	}

	@Override
	public List<Event> getEvents() {

		HttpSession session = getThreadLocalRequest().getSession();
		UploadProgress uploadProgress = UploadProgress.getUploadProgress(session);

		List<Event> events = null;
		if (null != uploadProgress) {
			if (uploadProgress.isEmpty()) {
				try {
					synchronized (uploadProgress) {
						_log.debug("waiting...");
						uploadProgress.wait(EVENT_WAIT);
					}
				} catch (final InterruptedException ie) {
					_log.debug("interrupted...");
				}
			}

			synchronized (uploadProgress) {
				events = uploadProgress.getEvents();
				uploadProgress.clear();
			}
		}
		return events;
	}
}
