/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client.upload.source.local;

import org.gcube.portlets.user.warmanagementwidget.client.upload.WarImportSession;
import org.gcube.portlets.user.warmanagementwidget.client.upload.source.WarSource;
import org.gcube.portlets.user.warmanagementwidget.client.wizard.WizardCard;

import com.extjs.gxt.ui.client.widget.Component;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class LocalSource implements WarSource {

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getId() {
		return "local";
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return "Local source";
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDescription() {
		return "Select this source if you want to upload the WAR file from your computer.";
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Component getPanel(WizardCard card, WarImportSession session) {
		return new LocalUploadPanel(card, session);
	}

}
