/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.management;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.portlets.user.warmanagementwidget.client.data.WarProfile;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgress;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationState;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class DemoService implements ServiceInterface {

	protected Map<String, WarProfile> profiles = new LinkedHashMap<String, WarProfile>();

	@Override
	public WarProfile getProfile(GCUBEScope scope, GCUBESecurityManager securityManager, String warId) {
		return profiles.get(warId);
	}

	@Override
	public OperationProgress uploadWar(String user, GCUBEScope scope, GCUBESecurityManager securityManager, String sessionId, WarProfile profile, File warFile, String baseUrl) {

		final OperationProgress operationProgress = new OperationProgress();
		
		Updater updater = new Updater(profile, operationProgress);
		Thread th = new Thread(updater);
		th.start();

		return operationProgress;
	}

	class Updater implements Runnable {
		protected OperationProgress operationProgress;
		protected WarProfile profile;

		/**
		 * @param operationProgress
		 */
		public Updater(WarProfile profile, OperationProgress operationProgress) {
			this.profile = profile;
			this.operationProgress = operationProgress;
		}

		public void run() {
			try {
				Thread.sleep(2000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			operationProgress.setElaboratedLenght(0);

			try {
				Thread.sleep(2000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			operationProgress.setElaboratedLenght(1);

			operationProgress.setState(OperationState.COMPLETED);

			if (profile.getApplicationId()==null) profile.setApplicationId(UUID.randomUUID().toString());
			
			profiles.put(profile.getApplicationId(), profile);
		}
	}

	@Override
	public OperationProgress deleteWar(String user, GCUBEScope scope, GCUBESecurityManager securityManager, String warId) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

}
