<%@include file="/init.jsp"%>

<!-- Inherit Generic public web-app portlet configuration parameters -->
<%
	String appURL_view = GetterUtil.getString(portletPreferences.getValue("appURL", StringPool.BLANK));
	String appURLTokenParam_view = GetterUtil
			.getString(portletPreferences.getValue("appURLTokenParam", StringPool.BLANK));
	Integer iFrameHeight = GetterUtil.getInteger(portletPreferences.getValue("iFrameHeightParam", "1000"));
	pageContext.setAttribute("iFrameHeight", iFrameHeight);
	
	boolean newAuthVersionPreference = GetterUtil.getBoolean(portletPreferences.getValue("newAuthVersionPreference", StringPool.FALSE));
	pageContext.setAttribute("newAuthVersionPreference", newAuthVersionPreference);
	
	boolean newWindowPreference = GetterUtil.getBoolean(portletPreferences.getValue("newWindowPreference", StringPool.FALSE));
	pageContext.setAttribute("newWindowPreference", newWindowPreference);
	
	String applicationNameParam_view = GetterUtil.getString(portletPreferences.getValue("applicationNameParam", "the Application"));
	pageContext.setAttribute("applicationNameParam_view", applicationNameParam_view);

	Object securityTokenObj = request.getAttribute("securityToken");
	String securityToken = "";
	if (securityTokenObj != null) {
		securityToken = securityTokenObj.toString();
	}
	
	Object encodedContextObj = request.getAttribute("encodedContext");
	String encodedContext = "";
	if (encodedContextObj != null) {
		encodedContext = encodedContextObj.toString();
	}

	/* handle the case where the page is called with GET parameters needing to be forwarded*/
	String completeURL = PortalUtil.getCurrentCompleteURL(request);
	String queryString = "";
	if (completeURL.indexOf("?") > 0) {
		String rawQueryString = completeURL.substring(completeURL.indexOf("?") + 1);
		// Filter out gcube-token parameters to prevent infinite loop
		String[] params = rawQueryString.split("&");
		StringBuilder filteredQuery = new StringBuilder();
		for (String param : params) {
			if (!param.startsWith("gcube-token=") && !param.startsWith("ide_webview_request_time=")) {
				if (filteredQuery.length() > 0) {
					filteredQuery.append("&");
				}
				filteredQuery.append(param);
			}
		}
		queryString = filteredQuery.toString().trim();
	}

	/* handle the case where the appURL provided has GET parameters needing to be forwarded*/
	if (appURL_view.indexOf("?") > 0) {
		if (queryString != null && !queryString.equals("")) { //not empty
			queryString += "&" + appURL_view.substring(appURL_view.indexOf("?") + 1);
		} else {
			queryString = appURL_view.substring(appURL_view.indexOf("?") + 1);
		}
		appURL_view = appURL_view.substring(0, appURL_view.indexOf("?"));
		queryString = queryString.trim();
	}

	//new IAM checked?
	if (newAuthVersionPreference) {
		securityToken = encodedContext;
	}
	
	String applicationURL = appURL_view;
	if (!appURLTokenParam_view.equals("")) {
		applicationURL += "?" + appURLTokenParam_view + "=" + securityToken;
		if (queryString != null && !queryString.equals("")) {
			applicationURL += "&" + queryString;
		}
	} else {
		if (queryString != null && !queryString.equals("")) {
			applicationURL += "?" + queryString;
		}
	}
	
	pageContext.setAttribute("applicationURL", applicationURL);
%>

<!-- Show configuration message if not configured -->
<c:if test="${empty applicationURL or applicationURL eq ''}">
	<div class="alert alert-info">
		<h4>VRE App Integration Portlet</h4>
		<p>This portlet needs to be configured with an Application URL.</p>
		<p>Please use the portlet configuration menu to set up the application.</p>
	</div>
</c:if>

<!-- Show portlet content if configured -->
<c:if test="${not empty applicationURL and applicationURL ne ''}">
	<c:choose>
		<c:when test="${not newWindowPreference}">
			<!-- iframe with CSP error handling -->
			<div id="iframeContainer">
				<iframe id="iFrameProxy" src="${applicationURL}" width="100%"
					marginwidth="0" marginheight="0" frameborder="0"
					height="${iFrameHeight}" style="overflow-x: hidden;"> </iframe>
			</div>
			
			<!-- CSP Error Fallback Message (initially hidden) -->
			<div id="cspErrorMessage" style="display: none;" class="alert alert-warning">
				<h4><i class="icon-warning-sign"></i> Content Security Policy Restriction</h4>
				<p>The application <strong>${applicationNameParam_view}</strong> cannot be displayed in an iframe due to security restrictions.</p>
				<p>Please click the button below to open it in a new window:</p>
				<a href="${applicationURL}" target="_blank" class="btn btn-primary">
					<i class="icon-external-link"></i> Open ${applicationNameParam_view}
				</a>
				<hr>
				<small class="text-muted">
					<strong>Technical note:</strong> This happens when external services implement Content Security Policy (CSP) 
					frame-ancestors restrictions. You can avoid this by enabling "Open in new window" in the portlet configuration.
				</small>
			</div>
			
			<script>
				// CSP Error Detection and Fallback
				(function() {
					var iframe = document.getElementById('iFrameProxy');
					var container = document.getElementById('iframeContainer');
					var errorMessage = document.getElementById('cspErrorMessage');
					var timeoutId;
					
					// Set a timeout to detect if iframe fails to load
					timeoutId = setTimeout(function() {
						// If iframe is still loading after 5 seconds, assume CSP error
						showCSPError();
					}, 5000);
					
					// Listen for iframe load events
					iframe.onload = function() {
						clearTimeout(timeoutId);
						try {
							// Try to access iframe content to detect CSP errors
							var iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
							if (!iframeDoc) {
								showCSPError();
							}
						} catch (e) {
							// Cross-origin or CSP error
							if (e.name === 'SecurityError' || e.message.indexOf('frame') !== -1) {
								showCSPError();
							}
						}
					};
					
					// Listen for iframe error events
					iframe.onerror = function() {
						clearTimeout(timeoutId);
						showCSPError();
					};
					
					function showCSPError() {
						container.style.display = 'none';
						errorMessage.style.display = 'block';
					}
				})();
			</script>
		</c:when>
		<c:otherwise>
			<div class="alert alert-info">
				<h4><i class="icon-external-link"></i> Opening ${applicationNameParam_view}</h4>
				<p>The application will open in a new window. If no new window appears, please click the link below:</p>
				<a href="${applicationURL}" target="_blank" class="btn btn-primary btn-lg">
					<i class="icon-external-link"></i> Open ${applicationNameParam_view}
				</a>
			</div>
			<script>
				// Open in new window with popup blocker detection
				(function() {
					var newWindow = window.open('${applicationURL}', '_blank');
					if (!newWindow || newWindow.closed || typeof newWindow.closed == 'undefined') {
						// Popup was blocked
						console.log('Popup blocked - user needs to click the link manually');
					}
				})();
			</script>
		</c:otherwise>
	</c:choose>
</c:if>