/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.uriresolvermanager.resolvers;

import java.util.Map;
import org.gcube.portlets.user.uriresolvermanager.entity.GenericResolver;
import org.gcube.portlets.user.uriresolvermanager.util.UrlEncoderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHUBResolver
extends GenericResolver {
    public static final Logger LOG = LoggerFactory.getLogger(SHUBResolver.class);

    public SHUBResolver(String resourceName, String entryName) {
        super(resourceName, entryName);
    }

    @Override
    public String getLink(String baseURI, Map<String, String> parameters) throws Exception {
        LOG.debug("called getLink: " + baseURI + " parameters: " + String.valueOf(parameters));
        String toReturn = null;
        try {
            String idValue = parameters.get("id");
            String pathURI = baseURI;
            if (idValue != null) {
                pathURI = "%s/%s".formatted(pathURI, idValue);
                parameters.remove("id");
            }
            toReturn = pathURI;
            String queryString = UrlEncoderUtil.encodeQuery(parameters);
            if (!queryString.isEmpty()) {
                toReturn = "%s?%s".formatted(pathURI, queryString);
            }
        }
        catch (Exception e) {
            LOG.error(SHUBResolver.class.getSimpleName() + " error:  ", (Throwable)e);
            throw e;
        }
        LOG.info("Got Link: " + toReturn);
        return toReturn;
    }
}

