/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.uriresolvermanager.resolvers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.gcube.portlets.user.uriresolvermanager.entity.GenericResolver;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogueResolverCallBuilder
extends GenericResolver {
    private static final int _60SEC = 60000;
    public static final Logger LOG = LoggerFactory.getLogger(CatalogueResolverCallBuilder.class);

    public CatalogueResolverCallBuilder(String resourceName, String entryName) {
        super(resourceName, entryName);
    }

    @Override
    public String getLink(String baseURI, Map<String, String> parameters) throws Exception {
        LOG.debug("called getLink: " + baseURI + " parameters: " + parameters);
        HttpURLConnection con = null;
        String theResponse = null;
        try {
            URL urlObj = new URL(baseURI);
            con = (HttpURLConnection)urlObj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            con.setDoOutput(true);
            con.setReadTimeout(60000);
            con.setConnectTimeout(60000);
            JSONObject jObj = new JSONObject();
            for (String key : parameters.keySet()) {
                jObj.put(key, (Object)parameters.get(key));
            }
            String toJSON = jObj.toString();
            LOG.info("Submitting JSON: " + toJSON);
            Integer code = null;
            try {
                OutputStream os = con.getOutputStream();
                os.write(toJSON.getBytes("UTF-8"));
                os.close();
                code = con.getResponseCode();
                theResponse = this.readResponse(con.getInputStream());
                if (200 > code || code > 208) {
                    throw new Exception("CatalogueResolver returned code: " + code + ". Response is: " + theResponse);
                }
            }
            catch (IOException e) {
                theResponse = this.readResponse(con.getInputStream());
                LOG.error("CatalogueResolver returned code: " + code + ". Response is: " + theResponse);
                throw e;
            }
        }
        catch (Exception e) {
            LOG.error(CatalogueResolverCallBuilder.class.getSimpleName() + " error:  ", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Exception exception) {}
        }
        LOG.info("Got Link: " + theResponse);
        return theResponse;
    }

    private String readResponse(InputStream ris) throws IOException {
        String line;
        BufferedInputStream in = new BufferedInputStream(ris);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder result = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }
}

