/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.uriresolvermanager.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlEncoderUtil {
    public static String charset = "UTF-8";
    protected static Logger logger = LoggerFactory.getLogger(UrlEncoderUtil.class);

    public static String encodeQuery(String ... parameters) {
        String query = "";
        for (String string : parameters) {
            try {
                query = query + URLEncoder.encode(string, charset) + "&";
            }
            catch (UnsupportedEncodingException e) {
                logger.error("encodeQuery error: ", (Throwable)e);
                return query;
            }
            catch (Exception e) {
                logger.error("encodeQuery error: ", (Throwable)e);
                return query;
            }
        }
        return UrlEncoderUtil.removeLastChar(query);
    }

    public static String encodeString(String theString) {
        String encodedQuery = "";
        if (theString == null || theString.isEmpty()) {
            return theString;
        }
        try {
            encodedQuery = URLEncoder.encode(theString, charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("encodeQuery error: ", (Throwable)e);
            return theString;
        }
        return encodedQuery;
    }

    public static String toQueryString(Map<String, String> parameters) {
        String query = "";
        if (parameters == null) {
            return query;
        }
        for (String key : parameters.keySet()) {
            try {
                query = query + String.format("%s=%s", key, parameters.get(key)) + "&";
            }
            catch (Exception e) {
                logger.error("getQueryString error: ", (Throwable)e);
                return query;
            }
        }
        return UrlEncoderUtil.removeLastChar(query);
    }

    public static String encodeQuery(Map<String, String> parameters) {
        String query = "";
        if (parameters == null) {
            return query;
        }
        for (String key : parameters.keySet()) {
            try {
                query = query + String.format(key + "=%s", URLEncoder.encode(parameters.get(key), charset)) + "&";
            }
            catch (UnsupportedEncodingException e) {
                logger.error("encodeQuery error: ", (Throwable)e);
                return query;
            }
            catch (Exception e) {
                logger.error("encodeQuery error: ", (Throwable)e);
                return query;
            }
        }
        return UrlEncoderUtil.removeLastChar(query);
    }

    public static String removeLastChar(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() > 0) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void main(String[] args) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("request", "GetStyles");
        parameters.put("layers", "test Name");
        parameters.put("version", "1.1.1");
        System.out.println(UrlEncoderUtil.encodeQuery(parameters));
    }
}

