/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.transect.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.io.FileUtils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphGroups;
import org.gcube.portlets.user.transect.client.TransectService;
import org.gcube.portlets.user.transect.server.ScopeNotFound;
import org.gcube.portlets.user.transect.server.readers.RuntimeResourceReader;
import org.gcube.portlets.user.transect.server.readers.entity.RuntimeProperty;
import org.gcube.portlets.user.transect.server.readers.entity.ServiceAccessPoint;
import org.gcube.portlets.user.transectgenerator.core.AquamapsProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TransectServiceImpl
extends RemoteServiceServlet
implements TransectService {
    private static final long serialVersionUID = 2417983362076766751L;
    private static final int GROUP_NUM = 1;
    public static final Logger logger = LoggerFactory.getLogger(TransectServiceImpl.class);
    public static final String TransectGeoDatabase = "TransectGeoDatabase";
    public static final String TransectAuxiliaryDatabase = "TransectAuxiliaryDatabase";
    private static boolean isInitialized = false;
    public static final String DIALECT = "dialect";
    public static final String DRIVER = "driver";

    public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
        super.service(arg0, arg1);
    }

    private static String fetchStringFromFile(String propertyName, Properties propFile) {
        return propFile.get(propertyName).toString();
    }

    private static String[] fetchArrayFromPropFile(String propertyName, Properties propFile) {
        return propFile.getProperty(propertyName).split(",");
    }

    public final GraphGroups populateData(String scope, int groupNum, String x1, String y1, String x2, String y2, String SRID, String maxelements, String minumumGap, String biodiversityfield, String tablename) throws Exception {
        logger.info("PopulateData start...");
        Properties props = new Properties();
        String cfgFolder = "cfg";
        String tablePropertiesPath = cfgFolder + File.separator + "table.properties";
        String realPath = this.getServletContext().getRealPath("/");
        logger.info("Trying to create full path, this.getServletContext().getRealPath(): " + realPath);
        InputStream resourceAsStream = null;
        if (realPath != null) {
            tablePropertiesPath = realPath + File.separator + tablePropertiesPath;
            File file = new File(tablePropertiesPath);
            resourceAsStream = FileUtils.openInputStream((File)file);
        } else {
            ServletContext context = this.getServletContext();
            resourceAsStream = context.getResourceAsStream(tablePropertiesPath);
        }
        logger.info("Trying to open inputstream for path: " + tablePropertiesPath);
        props.load(resourceAsStream);
        String _x1 = x1 != null ? x1 : TransectServiceImpl.fetchStringFromFile((String)"x1", (Properties)props);
        String _y1 = y1 != null ? y1 : TransectServiceImpl.fetchStringFromFile((String)"y1", (Properties)props);
        String _x2 = x2 != null ? x2 : TransectServiceImpl.fetchStringFromFile((String)"x2", (Properties)props);
        String _y2 = y2 != null ? y2 : TransectServiceImpl.fetchStringFromFile((String)"y2", (Properties)props);
        String _SRID = SRID != null ? SRID : TransectServiceImpl.fetchStringFromFile((String)"SRID", (Properties)props);
        int _maxelements = maxelements != null ? Integer.parseInt(maxelements) : Integer.parseInt(TransectServiceImpl.fetchStringFromFile((String)"maxelements", (Properties)props));
        int _minumumGap = minumumGap != null ? Integer.parseInt(minumumGap) : Integer.parseInt(TransectServiceImpl.fetchStringFromFile((String)"minumumGap", (Properties)props));
        String _biodiversityfield = biodiversityfield != null ? biodiversityfield : TransectServiceImpl.fetchStringFromFile((String)"biodiversityfield", (Properties)props);
        String _tablename = tablename != null ? tablename : TransectServiceImpl.fetchStringFromFile((String)"tablename", (Properties)props);
        AquamapsProcessor STG = null;
        try {
            LexicalEngineConfiguration aquamapsconfig = this.getDatabaseConfig(scope, "TransectAuxiliaryDatabase");
            LexicalEngineConfiguration geoserverconfig = this.getDatabaseConfig(scope, "TransectGeoDatabase");
            STG = new AquamapsProcessor();
            String cfg = realPath != null ? realPath + File.separator + cfgFolder + File.separator : cfgFolder + File.separator;
            logger.info("AquamapsProcessor init connections..., cfg path: " + cfg);
            STG.init(cfg, aquamapsconfig, geoserverconfig);
            logger.info("PopulateData calculating transect...");
            GraphGroups graphGroups = STG.calculateTransect(_x1, _y1, _x2, _y2, _SRID, _tablename, _biodiversityfield, _maxelements, _minumumGap);
            return graphGroups;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new Exception("Sorry an error occurred with connection to the Transect DB, try again later");
        }
        finally {
            if (STG != null) {
                STG.shutdown();
                logger.info("AquamapsProcessor shutdown connections!");
            }
        }
    }

    public LexicalEngineConfiguration getDatabaseConfig(String scope, String runtimeResourceName) throws Exception {
        logger.info("Trying read runtime name: " + runtimeResourceName + ", in scope: " + scope);
        RuntimeResourceReader rr = new RuntimeResourceReader(scope, runtimeResourceName);
        ServiceAccessPoint accessPoint = (ServiceAccessPoint)rr.getServiceAccessPoints().get(0);
        if (accessPoint == null) {
            throw new Exception("Access Point not found for " + runtimeResourceName + " in scope: " + scope);
        }
        logger.info("Access Point found for " + runtimeResourceName + " in scope: " + scope);
        RuntimeProperty rdialect = (RuntimeProperty)accessPoint.getRuntimeProperties().get("dialect");
        if (rdialect == null || rdialect.getValue() == null || rdialect.getValue().isEmpty()) {
            throw new Exception("property dialect not found or is empty");
        }
        RuntimeProperty rdriver = (RuntimeProperty)accessPoint.getRuntimeProperties().get("driver");
        if (rdriver == null || rdriver.getValue() == null || rdriver.getValue().isEmpty()) {
            throw new Exception("property driver not found or is empty");
        }
        logger.info("Returning " + runtimeResourceName + " configs: " + "\nusername: " + accessPoint.getUsername() + "" + "\npwd: " + accessPoint.getPwd() + "" + "\nservice URL: " + accessPoint.getServiceUrl() + "" + "\n" + "dialect" + ": " + rdialect.getValue() + "" + "\n" + "driver" + ": " + rdriver.getValue());
        LexicalEngineConfiguration lecongifs = new LexicalEngineConfiguration();
        lecongifs.setDatabaseUserName(accessPoint.getUsername());
        lecongifs.setDatabasePassword(accessPoint.getPwd());
        lecongifs.setDatabaseDialect(rdialect.getValue());
        lecongifs.setDatabaseDriver(rdriver.getValue());
        lecongifs.setDatabaseURL(accessPoint.getServiceUrl());
        return lecongifs;
    }

    public final GraphGroups getChartData(String scope, String x1, String y1, String x2, String y2, String SRID, String maxelements, String minumumGap, String biodiversityfield, String tablename) throws Exception {
        try {
            String scopeToUse;
            String scopeProvider = ScopeProvider.instance.get();
            logger.info("Scope provider: " + scopeProvider);
            logger.info("Parameter scope: " + scope);
            String string = scopeToUse = scopeProvider == null || scopeProvider.isEmpty() ? scope : scopeProvider;
            if (scopeToUse == null || scopeToUse.isEmpty()) {
                throw new ScopeNotFound("Parameter 'scope' not found, set 'scope=value' in query string");
            }
            logger.info("Using scope to read RR: " + scopeToUse);
            return this.populateData(scopeToUse, 1, x1, y1, x2, y2, SRID, maxelements, minumumGap, biodiversityfield, tablename);
        }
        catch (ScopeNotFound e) {
            logger.warn("Scope not found: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            logger.error("Exception on getChartData: ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }
}

