/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.templates.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtil {
    private static final Logger _log = LoggerFactory.getLogger(ZipUtil.class);

    public static void zipDir(String zipFileName, String dir) throws IOException {
        File dirObj = new File(dir);
        if (!dirObj.isDirectory()) {
            _log.error(String.valueOf(dir) + " is not a directory");
            System.exit(1);
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        _log.debug("Creating : " + zipFileName);
        ZipUtil.addDir((File)dirObj, (ZipOutputStream)out);
        out.close();
    }

    private static void addDir(File dirObj, ZipOutputStream out) throws IOException {
        File[] files = dirObj.listFiles();
        byte[] tmpBuf = new byte[1024];
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                ZipUtil.addDir((File)files[i], (ZipOutputStream)out);
            } else {
                int len;
                FileInputStream in = new FileInputStream(files[i].getAbsolutePath());
                _log.trace(" Adding: " + files[i].getAbsolutePath());
                String filename = files[i].getName();
                String ext = filename.substring(filename.length() - 4, filename.length());
                if (ext.equalsIgnoreCase(".jpg") || ext.equalsIgnoreCase(".gif") || ext.equalsIgnoreCase(".png") || ext.equalsIgnoreCase("jpeg")) {
                    filename = "images/" + filename;
                }
                out.putNextEntry(new ZipEntry(filename));
                while ((len = in.read(tmpBuf)) > 0) {
                    out.write(tmpBuf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            ++i;
        }
    }

    public static void unzipArchive(File archive, File outputDir) {
        try {
            ZipFile zipfile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                ZipUtil.unzipEntry((ZipFile)zipfile, (ZipEntry)entry, (File)outputDir);
            }
        }
        catch (Exception e) {
            _log.error("Error while extracting file " + archive);
        }
    }

    private static void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            ZipUtil.createDir((File)new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            ZipUtil.createDir((File)outputFile.getParentFile());
        }
        _log.trace("Extracting: " + entry);
        BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    private static void createDir(File dir) {
        _log.trace("Creating dir " + dir.getName());
        if (!dir.mkdirs()) {
            throw new RuntimeException("Can not create dir " + dir);
        }
    }
}

