/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.templates.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.d4sreporting.common.server.ServiceUtil;
import org.gcube.portlets.d4sreporting.common.shared.BasicSection;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.Model;
import org.gcube.portlets.user.templates.client.TemplateService;
import org.gcube.portlets.user.templates.server.ZipUtil;
import org.gcube.portlets.user.templates.server.loggers.CreateTemplateLogEntry;
import org.gcube.portlets.user.templates.server.loggers.OpenTemplateLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateServiceImpl
extends RemoteServiceServlet
implements TemplateService {
    private static final Logger _log = LoggerFactory.getLogger(TemplateServiceImpl.class);

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            user = "massimiliano.assante";
            this.getThreadLocalRequest().getSession().setAttribute("username", (Object)user);
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public void delTemplateDir(File dir) {
        try {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.delTemplateDir(files[i]);
                }
                files[i].delete();
            }
        }
        catch (NullPointerException n) {
            _log.error("Nothing 2 delete");
        }
    }

    private boolean getTemplateFromBasket(ReportTemplate repTmp, String pathToFile, String filename) {
        try {
            int len;
            File dir = new File(pathToFile);
            _log.trace("DIR: " + pathToFile);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File f = new File(pathToFile + filename);
            InputStream inputStream = null;
            try {
                inputStream = repTmp.getData();
            }
            catch (InternalErrorException e) {
                e.printStackTrace();
                return false;
            }
            FileOutputStream out = new FileOutputStream(f);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            inputStream.close();
            _log.debug("Successfully got ReportTemplate from Basket: " + pathToFile);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String[] getUserAndScope() {
        this.getASLSession();
        String[] toReturn = new String[]{this.getUsername(), this.getVreName()};
        return toReturn;
    }

    public String getUsername() {
        HttpServletRequest httpServletRequest = this.getThreadLocalRequest();
        HttpSession session = httpServletRequest.getSession();
        String user = (String)session.getAttribute("username");
        if (session.getAttribute("username") == null) {
            user = "massimiliano.assante";
            _log.debug("D4ScienceSession user NULL set to: " + user);
        }
        _log.debug("D4ScienceSession user: " + user);
        ASLSession d4session = SessionManager.getInstance().getASLSession(session.getId(), user);
        d4session.setAttribute("username", (Object)user);
        return user;
    }

    public String[] getUserTemplateNames() {
        ServiceUtil myUtil = new ServiceUtil(this.getASLSession());
        Vector<String> tmp = new Vector<String>();
        String userDir = myUtil.getTemplateFolder(this.getVreName(), this.getUsername());
        File f = new File(userDir);
        if (!f.exists()) {
            try {
                f.mkdirs();
                return new String[0];
            }
            catch (SecurityException ex) {
                return new String[0];
            }
        }
        File[] f2 = f.listFiles();
        for (int i = 0; i < f2.length; ++i) {
            if (!f2[i].isDirectory()) continue;
            tmp.add(f2[i].getName());
        }
        return tmp.toArray(new String[0]);
    }

    public String getVreName() {
        String scope = "";
        ASLSession aSLsession = this.getASLSession();
        scope = aSLsession.getScopeName();
        if (scope.charAt(0) == '/') {
            scope = scope.substring(1, scope.length());
        }
        _log.trace("TemplateGenServlet SCOPE: " + scope);
        return scope;
    }

    protected Workspace getWorkspaceArea() throws WorkspaceFolderNotFoundException, InternalErrorException, HomeNotFoundException {
        return HomeLibrary.getUserWorkspace((String)this.getASLSession().getUsername());
    }

    private WorkspaceFolder getWorkspaceInstance(String folderid) {
        Workspace root = null;
        WorkspaceItem item = null;
        try {
            root = this.getWorkspaceArea();
            item = root.getItem(folderid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        _log.debug("Item Type: " + item.getType());
        if (item.getType() == WorkspaceItemType.FOLDER || item.getType() == WorkspaceItemType.SHARED_FOLDER) {
            return (WorkspaceFolder)item;
        }
        _log.error("The item id does not belong to a valid folder id:" + folderid);
        return null;
    }

    public Model readModel(String templateName, String templateObjectID, boolean isImporting) {
        Workspace root = null;
        try {
            root = this.getWorkspaceArea();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WorkspaceItem item = null;
        try {
            item = root.getItem(templateObjectID);
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
        _log.debug("getItem: " + templateObjectID);
        ServiceUtil myUtil = new ServiceUtil(this.getASLSession());
        if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
            _log.trace("Item is a BASKET_ITEM");
            FolderItem bi = (FolderItem)item;
            if (bi.getFolderItemType() == FolderItemType.REPORT_TEMPLATE) {
                _log.trace("Item is a REPORT_TEMPLATE");
                ReportTemplate zippedTemplate = (ReportTemplate)bi;
                String zipFilename = templateName + ".zip";
                String zipPath = myUtil.getTemplatePath(templateName, this.getVreName(), this.getUsername());
                boolean fromBasket = this.getTemplateFromBasket(zippedTemplate, zipPath, zipFilename);
                String zipToExtract = zipPath + zipFilename;
                if (fromBasket) {
                    File toExtract = new File(zipToExtract);
                    File outputDir = new File(myUtil.getTemplatePath(templateName, this.getVreName(), this.getUsername()));
                    ZipUtil.unzipArchive((File)toExtract, (File)outputDir);
                    String templatePath = myUtil.getTemplatePath(templateName, this.getVreName(), this.getUsername());
                    String fileToRead = templatePath + "CURRENT_OPEN" + ".d4st";
                    _log.trace("Loading fileToRead from Disk");
                    Model toReturn = null;
                    Model toConvert = null;
                    FileInputStream fis = null;
                    ObjectInputStream in = null;
                    try {
                        fis = new FileInputStream(fileToRead);
                        in = new ObjectInputStream(fis);
                        toConvert = (Model)in.readObject();
                        in.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    _log.trace("Converting fileToRead to Serializable object");
                    if (toConvert == null) {
                        return null;
                    }
                    toReturn = toConvert;
                    toReturn.setTemplateName(templateName);
                    File toDelete = new File(zipToExtract);
                    toDelete.delete();
                    _log.trace("Converted, Author:" + toReturn.getAuthor());
                    if (!isImporting) {
                        this.getASLSession().setAttribute("currTemplateID", (Object)templateObjectID);
                        _log.trace("****\n\n STORING CURRENT OPEN TEMPLATE WITH ID = " + templateObjectID);
                        this.storeTemplateInSession(toReturn);
                    }
                    AccessLogger log = AccessLogger.getAccessLogger();
                    OpenTemplateLogEntry logEntry = new OpenTemplateLogEntry(toReturn.getTemplateName(), templateObjectID);
                    log.logEntry(this.getASLSession().getUsername(), this.getASLSession().getScopeName(), (AccessLogEntry)logEntry);
                    return toReturn;
                }
            }
            _log.error("FAILED TO READ RETURING EMPTY Serializable Template");
            return new Model();
        }
        _log.error("FAILED TO READ FROM BASKET RETURING EMPTY Serializable Template");
        return new Model();
    }

    public Model readTemplateFromSession() {
        _log.debug("READING TEMPLATE FROM SESSION ");
        ASLSession aslSession = this.getASLSession();
        String templateid = (String)aslSession.getAttribute("idtemplate");
        String templateName = "";
        _log.debug("Session Id = " + aslSession.getExternalSessionID());
        _log.debug("templateid  NULL? " + (aslSession.getAttribute("idtemplate") == null));
        if (templateid != null) {
            _log.debug("templateid NOT NULL");
            if (!templateid.equals("")) {
                aslSession.setAttribute("idtemplate", (Object)"");
                Workspace root = null;
                WorkspaceItem item = null;
                try {
                    root = this.getWorkspaceArea();
                    item = root.getItem(templateid);
                    templateName = item.getName();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return this.readModel(templateName, templateid, false);
            }
            if (aslSession.getAttribute("myTemplate") != null) {
                return (Model)aslSession.getAttribute("myTemplate");
            }
            return null;
        }
        _log.debug("READING TEMPLATE FROM SESSION... template null?" + (aslSession.getAttribute("myTemplate") == null));
        if (aslSession.getAttribute("myTemplate") != null) {
            _log.trace("getAttribute(\"myTemplate\")...");
            Model model = (Model)aslSession.getAttribute("myTemplate");
            _log.trace("secNo returned: " + model.getSections().size());
            return model;
        }
        ServiceUtil myUtil = new ServiceUtil(this.getASLSession());
        String dirToClean = myUtil.getTemplateFolder(this.getVreName(), this.getUsername());
        _log.trace("RETURNING> NULL, going to clean user template area: " + dirToClean);
        this.delTemplateDir(new File(dirToClean));
        return null;
    }

    public void saveTemplate(String basketidToSaveIn, Model model) {
        String templateName = model.getTemplateName();
        if (model.getAuthor() == null) {
            model.setAuthor(this.getUsername());
            _log.trace("Model author was Null: ");
        }
        if (model.getDateCreated() == null) {
            model.setDateCreated(new Date());
            _log.trace("getDateCreated  was Null: ");
        }
        model.setLastEdit(new Date());
        model.setLastEditBy(this.getUsername());
        _log.trace("Serializing Model, author: " + this.getUsername() + "\n*************\n**************\n date created:" + model.getDateCreated());
        model.getMetadata().clear();
        model.getMetadata().add(new Metadata("Author", model.getAuthor()));
        model.getMetadata().add(new Metadata("Created", "" + model.getDateCreated()));
        model.getMetadata().add(new Metadata("LastEdit", "" + model.getLastEdit()));
        model.getMetadata().add(new Metadata("LastEditBy", "" + model.getLastEditBy()));
        model.getMetadata().add(new Metadata("SectionsNo", "" + model.getSections().size()));
        for (BasicSection ss : model.getSections()) {
            ss.getMetadata().clear();
            ss.getMetadata().add(new Metadata("Author", model.getAuthor()));
            ss.getMetadata().add(new Metadata("Created", "" + model.getDateCreated()));
            ss.getMetadata().add(new Metadata("LastEdit", "" + model.getLastEdit()));
            ss.getMetadata().add(new Metadata("LastEditBy", "" + model.getLastEditBy()));
        }
        ServiceUtil myUtil = new ServiceUtil(this.getASLSession());
        boolean result = myUtil.writeModel(model, templateName, this.getVreName(), this.getUsername());
        if (!result) {
            _log.error("Could not save template, serializing failed");
        } else {
            String templatePath = myUtil.getTemplateFolder(this.getVreName(), this.getUsername());
            templatePath = templatePath + "CURRENT_OPEN";
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            _log.trace("Trying to zip folder: " + templatePath);
            String folderToZip = templatePath;
            String outZip = templatePath + ".zip";
            try {
                ZipUtil.zipDir((String)outZip, (String)folderToZip);
            }
            catch (IOException e) {
                _log.trace("Could not zip template, serializing failed");
                e.printStackTrace();
            }
            _log.trace("Folder zipped, result: " + outZip);
            try {
                WorkspaceFolder toSaveIn;
                BufferedInputStream isZip = new BufferedInputStream(new FileInputStream(outZip));
                if (basketidToSaveIn == null) {
                    _log.trace("\n\nSAVE TEMPLATE CALLED");
                    String templateid = "";
                    try {
                        templateid = this.getASLSession().getAttribute("currTemplateID").toString();
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    Workspace root = null;
                    WorkspaceItem item = null;
                    try {
                        root = this.getWorkspaceArea();
                        if (!templateid.equals("")) {
                            _log.trace("*********************+------+**********************\n\n TRYING TO GET ITEM WITH ID = " + templateid);
                            item = root.getItem(templateid);
                            basketidToSaveIn = item.getParent().getId();
                        } else {
                            basketidToSaveIn = root.getRoot().getId();
                            _log.trace("*********************---------**********************\n\n ITEM ID WAS EMPTY SAVING TO Root");
                        }
                    }
                    catch (WorkspaceFolderNotFoundException e) {
                        _log.error("******\n\n\n\nItem id=" + templateid + " has not been found\n\n\n*********");
                    }
                    catch (InternalErrorException e) {
                        e.printStackTrace();
                    }
                    catch (HomeNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (ItemNotFoundException e) {
                        e.printStackTrace();
                    }
                    _log.trace("BASKET ID: " + basketidToSaveIn);
                }
                if ((toSaveIn = this.getWorkspaceInstance(basketidToSaveIn)).exists(templateName)) {
                    _log.trace("Item exists already, deleting and creating new one");
                    toSaveIn.removeChild(toSaveIn.find(templateName));
                }
                if (toSaveIn.exists(templateName + ".d4sT")) {
                    _log.trace("Item exists already, deleting and creating new one");
                    toSaveIn.removeChild(toSaveIn.find(templateName + ".d4sT"));
                }
                String templateToInsert = templateName;
                if (!templateName.endsWith(".d4sT")) {
                    templateToInsert = templateToInsert + ".d4sT";
                }
                Calendar dateCreated = Calendar.getInstance();
                dateCreated.setTime(model.getDateCreated());
                Calendar lastEdit = Calendar.getInstance();
                lastEdit.setTime(model.getLastEdit());
                ReportTemplate inserted = toSaveIn.createReportTemplateItem(templateToInsert, templateToInsert, dateCreated, lastEdit, model.getAuthor(), model.getLastEditBy(), model.getSections().size(), "no-status", (InputStream)isZip);
                this.getASLSession().setAttribute("currTemplateID", (Object)inserted.getId());
                AccessLogger log = AccessLogger.getAccessLogger();
                CreateTemplateLogEntry logEntry = new CreateTemplateLogEntry(model.getTemplateName(), inserted.getId());
                log.logEntry(this.getASLSession().getUsername(), this.getASLSession().getScopeName(), (AccessLogEntry)logEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void storeTemplateInSession(Model model) {
        ASLSession d4Session = this.getASLSession();
        d4Session.setAttribute("myTemplate", (Object)model);
        try {
            _log.trace("Sec total: " + model.getSections().size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void renewHTTPSession() {
        HttpSession session = this.getThreadLocalRequest().getSession();
        _log.info("HTTP Session renewed" + new Date(session.getLastAccessedTime()));
    }
}

