/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.templates.client.components;

import com.extjs.gxt.ui.client.widget.Info;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portlets.d4sreporting.common.client.uicomponents.ReportUIComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.SerializableTable;
import org.gcube.portlets.d4sreporting.common.shared.TableCell;
import org.gcube.portlets.user.templates.client.components.GenTableCell;
import org.gcube.portlets.user.templates.client.components.GenericTable;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

public class GenericTable
extends ReportUIComponent {
    public static final int DEFAULT_HEIGHT = 200;
    public static final int DEFAULT_ROWS_NUM = 5;
    public static final int DEFAULT_COLS_NUM = 2;
    private VerticalPanel myPanel;
    private FlexTable myTable;
    Presenter presenter;
    private int rows;
    private int cols;
    private boolean isEditTableMode = false;
    private Button cellMerger = new Button("Merge Cells");
    private Button colMerger = new Button("Merge Selected Cells");
    private Button cancel = new Button("Cancel");
    private Button addRowB = new Button("Add Row");
    private Button addColB = new Button("Add Col");
    private int cellWidth;
    private int cellSpacing = 1;
    private int cellPadding = 0;
    private GenTableCell selectedCell = null;
    ClickHandler cellClicker = new /* Unavailable Anonymous Inner Class!! */;

    public GenericTable(int rows, int cols, ComponentType type, Presenter presenter, int left, int top, int width, int height, boolean hideControls) {
        super(type, left, top, width, height);
        this.presenter = presenter;
        this.commonConstructorCode(presenter);
        this.rows = rows;
        this.cols = cols;
        this.cellWidth = this.getCellWidth(cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                GenTableCell toAdd = new GenTableCell(i, j, this.cellWidth, 1);
                toAdd.setStyleName("tableBorder");
                toAdd.setWidth("" + this.cellWidth + "px");
                this.myTable.setWidget(i, j, (Widget)toAdd);
                toAdd.addClickHandler(this.cellClicker);
            }
        }
        this.myPanel = this.getResizablePanel();
        if (hideControls) {
            this.hideCloseButton();
        }
        ScrollPanel scroller = new ScrollPanel();
        scroller.setPixelSize(width, height - 30);
        scroller.add((Widget)this.myTable);
        this.myPanel.add((Widget)this.getControlPanel());
        this.myPanel.add((Widget)scroller);
        this.setStyleName("d4sFrame");
    }

    public GenericTable(SerializableTable sTable, Presenter presenter, int top, int left, int width, int height, boolean isLocked) {
        super(ComponentType.FLEX_TABLE, left, top, width, height);
        this.setLocked(isLocked);
        this.commonConstructorCode(presenter);
        this.rows = sTable.getRowCount();
        this.cols = sTable.getColsNo();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < sTable.getCellCount(i); ++j) {
                TableCell toPut = sTable.getValue(i, j);
                int cellWidth = toPut.getCellWidth();
                int colspan = toPut.getColspan();
                GenTableCell toAdd = new GenTableCell(i, j, cellWidth, colspan);
                toAdd.setText(toPut.getContent());
                toAdd.setStyleName("tableBorder");
                toAdd.setWidth("" + cellWidth + "px");
                this.myTable.setWidget(i, j, (Widget)toAdd);
                this.myTable.getFlexCellFormatter().setColSpan(i, j, colspan);
                toAdd.addClickHandler(this.cellClicker);
            }
        }
        this.myPanel = this.getResizablePanel();
        ScrollPanel scroller = new ScrollPanel();
        scroller.setPixelSize(width, height - 30);
        scroller.add((Widget)this.myTable);
        this.myPanel.add((Widget)this.getControlPanel());
        this.myPanel.add((Widget)scroller);
        this.setStyleName("d4sFrame");
    }

    private void commonConstructorCode(Presenter presenter) {
        this.presenter = presenter;
        this.myTable = new FlexTable();
        this.myTable.setWidth("90%");
        this.myTable.setCellSpacing(this.cellSpacing);
        this.myTable.setCellPadding(this.cellPadding);
    }

    private int getCellWidth(int cols) {
        int cellWidth = this.width / cols - (cols + 5);
        if (cols == 2 || cols == 3) {
            cellWidth -= 15;
        }
        if (cols == 4) {
            cellWidth -= 2;
        }
        if (cols > 6) {
            cellWidth += cols / 2;
        }
        GWT.log((String)("Cell WIdth: " + cellWidth));
        return cellWidth;
    }

    private HorizontalPanel getControlPanel() {
        HorizontalPanel toReturn = new HorizontalPanel();
        1 l = new /* Unavailable Anonymous Inner Class!! */;
        this.addRowB.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addColB.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.cellMerger.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        toReturn.add((Widget)this.addRowB);
        toReturn.add((Widget)this.addColB);
        toReturn.add((Widget)this.cellMerger);
        toReturn.add((Widget)this.colMerger);
        toReturn.add((Widget)this.cancel);
        this.colMerger.setVisible(false);
        this.cancel.setVisible(false);
        toReturn.setSpacing(3);
        this.cancel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.colMerger.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return toReturn;
    }

    private void endEditMode() {
        this.isEditTableMode = false;
        this.myTable.removeStyleName("highlight_background");
        this.cellMerger.setEnabled(true);
        this.colMerger.setVisible(false);
        this.cancel.setVisible(false);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                try {
                    GenTableCell tc = (GenTableCell)this.myTable.getWidget(i, j);
                    if (!tc.isSelected()) continue;
                    tc.selected = false;
                    tc.removeStyleName("selectedCell");
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void mergeSelectedCols() {
        block2: for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                try {
                    int nToMerge;
                    GenTableCell tc = (GenTableCell)this.myTable.getWidget(i, j);
                    if (!tc.isSelected() || (nToMerge = this.checkContiguosColsPerRows(i, j)) <= 1) continue;
                    int[] cellsData = this.deleteCells(i, j + 1, nToMerge - 1);
                    int colSpanDeleted = cellsData[0];
                    int deletedCellWidth = cellsData[1];
                    tc.setColspan(tc.getColspan() + colSpanDeleted);
                    GWT.log((String)("i=" + i + " j=" + j + " nTomerge" + nToMerge + " COLSPAN: " + tc.getColspan()));
                    this.myTable.getFlexCellFormatter().setColSpan(i, j, tc.getColspan());
                    int newWidth = tc.getWidth() + deletedCellWidth + this.cellSpacing * tc.getColspan() + tc.getColspan();
                    tc.setWidth(newWidth + "px");
                    tc.setCellWidth(newWidth);
                    tc.removeStyleName("selectedCell");
                    continue block2;
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private int[] deleteCells(int row, int col, int num) {
        int[] toReturn = new int[]{0, 0};
        for (int j = col; j < col + num; ++j) {
            toReturn[0] = toReturn[0] + ((GenTableCell)this.myTable.getWidget(row, j)).getColspan();
            toReturn[1] = toReturn[1] + ((GenTableCell)this.myTable.getWidget(row, j)).getCellWidth();
        }
        this.myTable.removeCells(row, col, num);
        GWT.log((String)("REMOVED CELL from" + col + " to " + (col + num)));
        return toReturn;
    }

    private int checkContiguosColsPerRows(int i, int j) {
        int counter = 1;
        GenTableCell next = (GenTableCell)this.myTable.getWidget(i, j);
        ++j;
        while (j < this.myTable.getCellCount(i) && (next = (GenTableCell)this.myTable.getWidget(i, j)).isSelected()) {
            ++counter;
            ++j;
        }
        return counter;
    }

    public FlexTable getMyTable() {
        return this.myTable;
    }

    public void setMyTable(FlexTable myTable) {
        this.myTable = myTable;
    }

    public int getRowsNo() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public SerializableTable getSerializable() {
        SerializableTable toReturn = new SerializableTable(this.cols);
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            toReturn.addRow(this.getRow(i));
        }
        return toReturn;
    }

    public ArrayList<TableCell> getRow(int i) {
        ArrayList<TableCell> toReturn = new ArrayList<TableCell>();
        for (int j = 0; j < this.myTable.getCellCount(i); ++j) {
            GenTableCell tb = (GenTableCell)this.myTable.getWidget(i, j);
            int colspan = tb.getColspan();
            toReturn.add(new TableCell(tb.getText(), colspan, tb.getWidth(), tb.getHeight()));
        }
        return toReturn;
    }

    private void setSelected(GenTableCell tc) {
        this.presenter.setSelectedComponent((ReportUIComponent)this);
        this.selectedCell = tc;
    }

    public GenTableCell getSelectedCell() {
        return this.selectedCell;
    }

    public void addRow() {
        SerializableTable sTable = this.getSerializable();
        int rowIndex = this.myTable.getRowCount();
        for (int j = 0; j < this.myTable.getCellCount(rowIndex - 1); ++j) {
            TableCell toPut = sTable.getValue(rowIndex - 1, j);
            int cellWidth = toPut.getCellWidth();
            int cellHeight = toPut.getCellHeight();
            int colspan = toPut.getColspan();
            GenTableCell toAdd = new GenTableCell(rowIndex, j, cellWidth, colspan);
            toAdd.setText(toPut.getContent());
            toAdd.setStyleName("tableBorder");
            toAdd.setWidth("" + cellWidth + "px");
            this.myTable.setWidget(rowIndex, j, (Widget)toAdd);
            this.myTable.getFlexCellFormatter().setColSpan(rowIndex, j, colspan);
            toAdd.addClickHandler(this.cellClicker);
        }
        ++this.rows;
        Info.display((String)"Info", (String)"Table Row added successfully");
    }

    public void addColumn() {
        int colIndex = this.cols;
        int cellWidth = this.getCellWidth(this.cols + 1);
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            GenTableCell toAdd = new GenTableCell(i, colIndex, cellWidth, 1);
            toAdd.setStyleName("tableBorder");
            GWT.log((String)("Width=" + cellWidth));
            this.myTable.setWidget(i, colIndex, (Widget)toAdd);
            toAdd.addClickHandler(this.cellClicker);
        }
        ++this.cols;
        this.updateCellWidth(this.getCellWidth(this.cols));
        Info.display((String)"Info", (String)"Table Column added successfully");
    }

    private void updateCellWidth(int newWidth) {
        SerializableTable sTable = this.getSerializable();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < sTable.getCellCount(i); ++j) {
                TableCell toPut = sTable.getValue(i, j);
                int cellWidth = newWidth;
                int colspan = toPut.getColspan();
                GenTableCell toAdd = new GenTableCell(i, j, cellWidth, colspan);
                toAdd.setText(toPut.getContent());
                toAdd.setStyleName("tableBorder");
                toAdd.setWidth("" + cellWidth + "px");
                this.myTable.setWidget(i, j, (Widget)toAdd);
                this.myTable.getFlexCellFormatter().setColSpan(i, j, colspan);
                toAdd.addClickHandler(this.cellClicker);
            }
        }
    }

    public void addColumnLeft(int colindex) {
    }

    public void deleteRow(int rowIndex) {
        if (this.myTable.getRowCount() == 1) {
            Info.display((String)"Error", (String)"Only one row left, delete the tableb");
        } else {
            this.myTable.removeRow(rowIndex);
            Info.display((String)"Info", (String)"Table Row removed successfully");
        }
    }

    public void lockComponent(ReportUIComponent toLock, boolean locked) {
        this.presenter.lockComponent((Widget)this, locked);
    }

    public void removeTemplateComponent(ReportUIComponent toRemove) {
        this.presenter.removeTemplateComponent((Widget)this);
    }

    static /* synthetic */ boolean access$000(GenericTable x0) {
        return x0.isEditTableMode;
    }

    static /* synthetic */ boolean access$002(GenericTable x0, boolean x1) {
        x0.isEditTableMode = x1;
        return x0.isEditTableMode;
    }

    static /* synthetic */ FlexTable access$100(GenericTable x0) {
        return x0.myTable;
    }

    static /* synthetic */ Button access$200(GenericTable x0) {
        return x0.cellMerger;
    }

    static /* synthetic */ Button access$300(GenericTable x0) {
        return x0.colMerger;
    }

    static /* synthetic */ Button access$400(GenericTable x0) {
        return x0.cancel;
    }

    static /* synthetic */ void access$500(GenericTable x0) {
        x0.endEditMode();
    }

    static /* synthetic */ void access$600(GenericTable x0) {
        x0.mergeSelectedCols();
    }

    static /* synthetic */ void access$700(GenericTable x0, GenTableCell x1) {
        x0.setSelected(x1);
    }
}

