/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.templates.client.components;

import com.extjs.gxt.ui.client.widget.Info;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portlets.d4sreporting.common.client.uicomponents.ReportUIComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.SerializableTable;
import org.gcube.portlets.d4sreporting.common.shared.TableCell;
import org.gcube.portlets.user.templates.client.components.GenTableCell;
import org.gcube.portlets.user.templates.client.components.GenericTable;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

public class GenericTable
extends ReportUIComponent {
    private VerticalPanel myPanel;
    private FlexTable myTable;
    Presenter presenter;
    private int rows;
    private int cols;
    private boolean isEditTableMode = false;
    private Button cellMerger = new Button("Merge Cells");
    private Button colMerger = new Button("Merge Selected Cells");
    private Button cancel = new Button("Cancel");
    private int cellWidth;
    private int cellSpacing = 1;
    private int cellPadding = 0;
    private GenTableCell selectedCell = null;
    ClickHandler cellClicker = new /* Unavailable Anonymous Inner Class!! */;

    public GenericTable(int rows, int cols, ComponentType type, Presenter presenter, int left, int top, int width, int height) {
        super(type, left, top, width, height);
        this.presenter = presenter;
        this.commonConstructorCode(presenter);
        this.rows = rows;
        this.cols = cols;
        this.cellWidth = width / cols - (cols + 5);
        if (cols == 2 || cols == 3) {
            this.cellWidth -= 15;
        }
        if (cols == 4) {
            this.cellWidth -= 2;
        }
        if (cols > 6) {
            this.cellWidth += cols / 2;
        }
        GWT.log((String)("Cell WIdth: " + this.cellWidth));
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                GenTableCell toAdd = new GenTableCell(i, j, this.cellWidth, 1);
                toAdd.setStyleName("tableBorder");
                toAdd.setWidth(this.cellWidth + "px");
                this.myTable.setWidget(i, j, (Widget)toAdd);
                toAdd.addClickHandler(this.cellClicker);
                ++j;
            }
            ++i;
        }
        this.myPanel = this.getResizablePanel();
        ScrollPanel scroller = new ScrollPanel();
        scroller.setPixelSize(width, height - 30);
        scroller.add((Widget)this.myTable);
        this.myPanel.add((Widget)this.getControlPanel());
        this.myPanel.add((Widget)scroller);
        this.setStyleName("d4sFrame");
    }

    public GenericTable(SerializableTable sTable, Presenter presenter, int top, int left, int width, int height) {
        super(ComponentType.FLEX_TABLE, left, top, width, height);
        this.commonConstructorCode(presenter);
        this.rows = sTable.getRowCount();
        this.cols = sTable.getColsNo();
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < sTable.getCellCount(i)) {
                TableCell toPut = sTable.getValue(i, j);
                int cellWidth = toPut.getCellWidth();
                int cellHeight = toPut.getCellHeight();
                int colspan = toPut.getColspan();
                GenTableCell toAdd = new GenTableCell(i, j, cellWidth, colspan);
                toAdd.setText(toPut.getContent());
                toAdd.setStyleName("tableBorder");
                toAdd.setWidth(cellWidth + "px");
                this.myTable.setWidget(i, j, (Widget)toAdd);
                this.myTable.getFlexCellFormatter().setColSpan(i, j, colspan);
                toAdd.addClickHandler(this.cellClicker);
                ++j;
            }
            ++i;
        }
        this.myPanel = this.getResizablePanel();
        ScrollPanel scroller = new ScrollPanel();
        scroller.setPixelSize(width, height - 30);
        scroller.add((Widget)this.myTable);
        this.myPanel.add((Widget)this.getControlPanel());
        this.myPanel.add((Widget)scroller);
        this.setStyleName("d4sFrame");
    }

    private void commonConstructorCode(Presenter presenter) {
        this.presenter = presenter;
        this.myTable = new FlexTable();
        this.myTable.setWidth("90%");
        this.myTable.setCellSpacing(this.cellSpacing);
        this.myTable.setCellPadding(this.cellPadding);
    }

    private HorizontalPanel getControlPanel() {
        HorizontalPanel toReturn = new HorizontalPanel();
        2 l = new /* Unavailable Anonymous Inner Class!! */;
        this.cellMerger.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        toReturn.add((Widget)this.cellMerger);
        toReturn.add((Widget)this.colMerger);
        toReturn.add((Widget)this.cancel);
        this.colMerger.setVisible(false);
        this.cancel.setVisible(false);
        toReturn.setSpacing(3);
        this.cancel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.colMerger.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return toReturn;
    }

    private void endEditMode() {
        this.isEditTableMode = false;
        this.myTable.removeStyleName("highlight_background");
        this.cellMerger.setEnabled(true);
        this.colMerger.setVisible(false);
        this.cancel.setVisible(false);
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                try {
                    GenTableCell tc = (GenTableCell)this.myTable.getWidget(i, j);
                    if (tc.isSelected()) {
                        tc.selected = false;
                        tc.removeStyleName("selectedCell");
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
    }

    private void mergeSelectedCols() {
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                try {
                    int nToMerge;
                    GenTableCell tc = (GenTableCell)this.myTable.getWidget(i, j);
                    if (tc.isSelected() && (nToMerge = this.checkContiguosColsPerRows(i, j)) > 1) {
                        int[] cellsData = this.deleteCells(i, j + 1, nToMerge - 1);
                        int colSpanDeleted = cellsData[0];
                        int deletedCellWidth = cellsData[1];
                        tc.setColspan(tc.getColspan() + colSpanDeleted);
                        GWT.log((String)("i=" + i + " j=" + j + " nTomerge" + nToMerge + " COLSPAN: " + tc.getColspan()));
                        this.myTable.getFlexCellFormatter().setColSpan(i, j, tc.getColspan());
                        int newWidth = tc.getWidth() + deletedCellWidth + this.cellSpacing * tc.getColspan() + tc.getColspan();
                        tc.setWidth(String.valueOf(newWidth) + "px");
                        tc.setCellWidth(newWidth);
                        tc.removeStyleName("selectedCell");
                        break;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
    }

    private int[] deleteCells(int row, int col, int num) {
        int[] toReturn = new int[]{0, 0};
        int j = col;
        while (j < col + num) {
            toReturn[0] = toReturn[0] + ((GenTableCell)this.myTable.getWidget(row, j)).getColspan();
            toReturn[1] = toReturn[1] + ((GenTableCell)this.myTable.getWidget(row, j)).getCellWidth();
            ++j;
        }
        this.myTable.removeCells(row, col, num);
        GWT.log((String)("REMOVED CELL from" + col + " to " + (col + num)));
        return toReturn;
    }

    private int checkContiguosColsPerRows(int i, int j) {
        int counter = 1;
        GenTableCell next = (GenTableCell)this.myTable.getWidget(i, j);
        ++j;
        while (j < this.myTable.getCellCount(i)) {
            next = (GenTableCell)this.myTable.getWidget(i, j);
            if (!next.isSelected()) break;
            ++counter;
            ++j;
        }
        return counter;
    }

    public FlexTable getMyTable() {
        return this.myTable;
    }

    public void setMyTable(FlexTable myTable) {
        this.myTable = myTable;
    }

    public int getRowsNo() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public SerializableTable getSerializable() {
        SerializableTable toReturn = new SerializableTable(this.cols);
        int i = 0;
        while (i < this.myTable.getRowCount()) {
            toReturn.addRow(this.getRow(i));
            ++i;
        }
        return toReturn;
    }

    public ArrayList<TableCell> getRow(int i) {
        ArrayList<TableCell> toReturn = new ArrayList<TableCell>();
        int j = 0;
        while (j < this.myTable.getCellCount(i)) {
            GenTableCell tb = (GenTableCell)this.myTable.getWidget(i, j);
            int colspan = tb.getColspan();
            toReturn.add(new TableCell(tb.getText(), colspan, tb.getWidth(), tb.getHeight()));
            ++j;
        }
        return toReturn;
    }

    private void setSelected(GenTableCell tc) {
        this.presenter.setSelectedComponent((ReportUIComponent)this);
        this.selectedCell = tc;
    }

    public GenTableCell getSelectedCell() {
        return this.selectedCell;
    }

    public void addRow(int rowIndex) {
        SerializableTable sTable = this.getSerializable();
        rowIndex = this.myTable.getRowCount();
        int j = 0;
        while (j < this.myTable.getCellCount(rowIndex - 1)) {
            TableCell toPut = sTable.getValue(rowIndex - 1, j);
            int cellWidth = toPut.getCellWidth();
            int cellHeight = toPut.getCellHeight();
            int colspan = toPut.getColspan();
            GenTableCell toAdd = new GenTableCell(rowIndex, j, cellWidth, colspan);
            toAdd.setText(toPut.getContent());
            toAdd.setStyleName("tableBorder");
            toAdd.setWidth(cellWidth + "px");
            this.myTable.setWidget(rowIndex, j, (Widget)toAdd);
            this.myTable.getFlexCellFormatter().setColSpan(rowIndex, j, colspan);
            toAdd.addClickHandler(this.cellClicker);
            ++j;
        }
        ++this.rows;
        Info.display((String)"Info", (String)"Table Row added successfully");
    }

    public void addColumnLeft(int colindex) {
    }

    public void deleteRow(int rowIndex) {
        if (this.myTable.getRowCount() == 1) {
            Info.display((String)"Error", (String)"Only one row left, delete the table");
        } else {
            this.myTable.removeRow(rowIndex);
            Info.display((String)"Info", (String)"Table Row removed successfully");
        }
    }

    public void lockComponent(ReportUIComponent toLock, boolean locked) {
        this.presenter.lockComponent((Widget)this, locked);
    }

    public void removeTemplateComponent(ReportUIComponent toRemove) {
        this.presenter.removeTemplateComponent((Widget)this);
    }

    static /* synthetic */ void access$0(GenericTable genericTable, GenTableCell genTableCell) {
        genericTable.setSelected(genTableCell);
    }

    static /* synthetic */ boolean access$1(GenericTable genericTable) {
        return genericTable.isEditTableMode;
    }

    static /* synthetic */ void access$2(GenericTable genericTable, boolean bl) {
        genericTable.isEditTableMode = bl;
    }

    static /* synthetic */ FlexTable access$3(GenericTable genericTable) {
        return genericTable.myTable;
    }

    static /* synthetic */ Button access$4(GenericTable genericTable) {
        return genericTable.cellMerger;
    }

    static /* synthetic */ Button access$5(GenericTable genericTable) {
        return genericTable.colMerger;
    }

    static /* synthetic */ Button access$6(GenericTable genericTable) {
        return genericTable.cancel;
    }

    static /* synthetic */ void access$7(GenericTable genericTable) {
        genericTable.endEditMode();
    }

    static /* synthetic */ void access$8(GenericTable genericTable) {
        genericTable.mergeSelectedCols();
    }
}

