/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template;

import java.util.List;

import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;
import org.gcube.portlets.user.tdtemplate.client.template.view.TemplateSwitcherInteface;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTemplateDefinition;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 29, 2014
 * 
 */
public abstract class SetColumnTypeDefinition {

	private TemplateSwitcherInteface templateSwitcherInteface;
	private List<TdTColumnCategory> listCategory;
	
	public abstract void updateListCategory();
	
	/**
	 * 
	 * @param templateType
	 *            is template category
	 */
	public SetColumnTypeDefinition(TemplateSwitcherInteface templateSwitcherInteface) {
		this.templateSwitcherInteface = templateSwitcherInteface;
		
		TdTemplateDefinition def = new TdTemplateDefinition(templateSwitcherInteface.getName(), templateSwitcherInteface.getDescription(), templateSwitcherInteface.getType(), templateSwitcherInteface.getAgency(), templateSwitcherInteface.getOnError());
		def.setServerId(templateSwitcherInteface.getServerId());
		
		GWT.log("Template definition is : "+def);
		
		TdTemplateController.tdTemplateServiceAsync.getColumnCategoryByTdTemplateDefinition(def,new AsyncCallback<List<TdTColumnCategory>>() {

			@Override
			public void onSuccess(List<TdTColumnCategory> result) {

				GWT.log("ColumnCategoryByTemplateId are: "+result);
				if (result != null){
					listCategory = result;
					updateListCategory();
				}
			}

			@Override
			public void onFailure(Throwable caught) {
				caught.printStackTrace();

			}
		});
	}


	public String getTemplateType() {
		return templateSwitcherInteface.getType();
	}


	public List<TdTColumnCategory> getListCategory() {
		return listCategory;
	}

}
