/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.gcube.portlets.user.td.widgetcommonevent.client.event.ExpressionEvent;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_ExpressionContainer;
import org.gcube.portlets.user.tdtemplate.client.event.ExpressionDialogOpenedEvent.ExpressionDialogType;
import org.gcube.portlets.user.tdtemplate.client.locale.LocaleViewManager;
import org.gcube.portlets.user.tdtemplate.client.resources.TdTemplateAbstractResources;
import org.gcube.portlets.user.tdtemplate.client.rpc.TdTemplateService;
import org.gcube.portlets.user.tdtemplate.client.rpc.TdTemplateServiceAsync;
import org.gcube.portlets.user.tdtemplate.client.template.TemplateGenerator;
import org.gcube.portlets.user.tdtemplate.client.template.view.ColumnDefinitionView;
import org.gcube.portlets.user.tdtemplate.client.template.view.TemplateFormSwitcherPanel;
import org.gcube.portlets.user.tdtemplate.client.template.view.TemplateSwitcherInteface;
import org.gcube.portlets.user.tdtemplate.shared.ClientReportTemplateSaved;
import org.gcube.portlets.user.tdtemplate.shared.SPECIAL_CATEGORY_TYPE;
import org.gcube.portlets.user.tdtemplate.shared.TdColumnDefinition;
import org.gcube.portlets.user.tdtemplate.shared.TdFlowModel;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTDataType;
import org.gcube.portlets.user.tdtemplate.shared.TdTTemplateType;
import org.gcube.portlets.user.tdtemplate.shared.TdTTimePeriod;
import org.gcube.portlets.user.tdtemplate.shared.TemplateExpression;
import org.gcube.portlets.user.tdtemplate.shared.validator.ViolationDescription;

import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.SimpleEventBus;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 8, 2014
 *
 */
public class TdTemplateController implements TdTemplateControllerState{
	
//	private static EventBus privateTaskBus = new SimpleEventBus();
	private static EventBus commonBus = new SimpleEventBus();
	protected TemplateFormSwitcherPanel switcher;
	  // Create a table to layout the content
	protected final LayoutContainer mainPanel = new LayoutContainer();
	protected int width = TdTemplateConstants.MAINWIDTH+5;
	protected int height = TdTemplateConstants.MAINHEIGHT+5;

	protected static TemplateRuleHandler templateRuleHandler;
	
    public static final TdTemplateServiceAsync tdTemplateServiceAsync = GWT.create(TdTemplateService.class);
	
    protected static TemplateGenerator tdGeneretor;
    protected Window window = new Window();
    
//    protected ToolBar submitTool = new ToolBar();
	private TdTemplatePrivateEventsBinder binder;
	
	protected List<String> listLocales;
	
	protected List<TdTTimePeriod> listPeriodTypes;
	
	protected ToolBar submitTool = new ToolBar();
	
	private LocaleViewManager localeViewManager;
    
    public static EventBus getInternalBus(){
    	return TdTemplatePrivateEventsBinder.privateTaskBus;
    }
    
    public static final int MAX_ZINDEX = 1012;
    
    protected String messageBoxTitle = TdTemplateConstants.TEMPLATE_CREATED;
    protected String messageBoxMsg = TdTemplateConstants.TEMPLATE_CREATED_SUCCESSFULLY+"!";
    private Map<String, Map<String, String>> timeFormatsIndexer = new HashMap<String, Map<String, String>>(); //periodName - Map Value Formats
    /**
	 * 
	 * @param bus
	 */
	public static void bindCommonBus(EventBus bus){
		commonBus = bus;
		bindCommonEvents();
	}
	
	public int getWindowZIndex(){
		return window.el().getZIndex();
	}
	
	
	
	protected static void bindCommonEvents() {

		commonBus.addHandler(ExpressionEvent.TYPE, new ExpressionEvent.ExpressionEventHandler() {
			
			@Override
			public void onExpression(ExpressionEvent event) {
				GWT.log("ExpressionEvent catched into Template");
				
				C_ExpressionContainer ruleContainer = event.getC_ConditionExpressionContainer();
				
				ColumnDefinitionView col = getTdGeneretor().getListColumnDefinition().get(templateRuleHandler.getIndexer().getColumnIndex());
				
				if(ruleContainer!=null && ruleContainer.getExp()!=null){

					if(col!=null){
						GWT.log("Added rule to: "+templateRuleHandler);
						TemplateExpression te = new TemplateExpression(ruleContainer.getExp(), ruleContainer.getReadableExpression());
						
						if(templateRuleHandler.getType().equals(ExpressionDialogType.NEW))
							col.addRule(te, true, true);
						else if(templateRuleHandler.getType().equals(ExpressionDialogType.UPDATE)){
							col.updateRule(templateRuleHandler.getIndexer().getExpressionIndex(), te, true, true);
						}
					}
						
				}
				else{
					GWT.log("Expression dialog closed with container as null");
//					col.deleteExpressionCaller(templateRuleHandler.getIndexer());
					templateRuleHandler = null;
//					MessageBox.alert("Expression event", event.getC_ExpressionContainer().toString(), null);
//					event.getC_ExpressionContainer();
				}
				
			}
		});
	}
    
	/**
	 * 
	 */
	protected void initToolbarSubmit() {
		Button butt = new Button("Save");
		butt.setIcon(TdTemplateAbstractResources.submit());
		submitTool.setEnabled(false);
		submitTool.add(new FillToolItem());
		submitTool.add(butt);
	
		
		butt.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {
				submitTemplateDefinition();
			}
		});
		
		window.layout();
	}
	
	@Override
	public void submitTemplateDefinition(){
		
		List<TdColumnDefinition> columns = getTdColumnDefintions();
		
		//TODO DEBUG
//		for (TdColumnDefinition tdColumnDefinition : columns) {
//			System.out.println(tdColumnDefinition);	
//		}
//		
		validateTemplate(columns);
//		createTemplate(columns);
	}
	

	public void createTemplate(List<TdColumnDefinition> columns){
		
		if(columns!=null && columns.size()>0){
		
			window.mask("Creating template");
			TdFlowModel flowAttached = getTdGeneretor().getTemplatePanel().getFlow();
			
			tdTemplateServiceAsync.submitTemplate(columns, flowAttached, new AsyncCallback<ClientReportTemplateSaved>() {
	
				@Override
				public void onFailure(Throwable caught) {
					window.unmask();
					MessageBox.alert(TdTemplateConstants.TEMPLATE_ERROR, TdTemplateConstants.TEMPLATE_CREATION_ERROR, null).show();
				}
	
				@Override
				public void onSuccess(ClientReportTemplateSaved result) {
					window.unmask();
					showReportTemplateSaved(result);
				}
			});
		}
		
	}
	
	protected void showReportTemplateSaved(ClientReportTemplateSaved result){
		DialogResult box = null;
		boolean error = false;
		Image img = null;
		
		if(result.isError() && result.getListErrorColumn()!=null){
			String withError = "with";
			int size = result.getListErrorColumn().size();
			withError+= size>1?" errors":" one error";
//			String column = size>1?" columns because they have ":" column because it has ";
			String column = size>1?" columns ":" column ";
			
			messageBoxTitle += " "+withError;
//			messageBoxMsg = "Skipped the following " +column +" generated an error:";
			messageBoxMsg = "Skipped the following " +column +":<br/>";
			
			for (TdColumnDefinition tdColumnDefinition : result.getListErrorColumn()) {
				TdTColumnCategory category = tdColumnDefinition.getCategory();
//				messageBoxMsg+="<br/>Column "+(tdColumnDefinition.getIndex()+1)+ " ("+category.getName()+")";
				messageBoxMsg+="<br/>*Column "+(tdColumnDefinition.getIndex()+1)+ " ("+category.getName()+") has generated an error";
			}
			
			error = true;
		}else{
			GWT.log("Template created correctly");
//			messageBoxMsg = TdTemplateConstants.TEMPLATE_CREATED_SUCCESSFULLY+"!";
		}

		if(error)
			img = TdTemplateAbstractResources.error().createImage();
		else
			img = TdTemplateAbstractResources.okicon().createImage();
		
		box = getDialog(img, messageBoxTitle, messageBoxMsg);			
		box.show();
		submitTool.disable();
		
		box.addCloseHandler(new CloseHandler<PopupPanel>() {
			
			@Override
			public void onClose(CloseEvent<PopupPanel> event) {
				window.hide();
				
			}
		});
	}
	
	/**
	 * 
	 */
	protected void validateTemplate(final List<TdColumnDefinition> columns) {
		
		List<TdTColumnCategory> listCategory = new ArrayList<TdTColumnCategory>();
		for (TdColumnDefinition tdColumnDefinition : columns) {
			listCategory.add(tdColumnDefinition.getCategory());
		}
		
		window.mask("Validating template");
		
		tdTemplateServiceAsync.isValidTemplate(listCategory, new AsyncCallback<Boolean>() {

			@Override
			public void onFailure(Throwable caught) {
				window.unmask();
				MessageBox.alert(TdTemplateConstants.TEMPLATE_ERROR, "Sorry, an error occurred when validating template, try again", null).show();
				
			}

			@Override
			public void onSuccess(Boolean result) {
				window.unmask();
				
				if(result){
					createTemplate(columns);
				}else{
					showViolations(columns);
				}
				
			}

			
		});

	}
	
	protected void showViolations(final List<TdColumnDefinition> columns) {
		
		tdTemplateServiceAsync.getTemplateConstraintsViolations(new AsyncCallback<List<ViolationDescription>>() {

			@Override
			public void onFailure(Throwable caught) {
				MessageBox.alert(TdTemplateConstants.TEMPLATE_ERROR, "Sorry, an error occurred on loading template violations, try again", null).show();
				
			}

			@Override
			public void onSuccess(List<ViolationDescription> result) {
				
				if(result.size()==0){
					createTemplate(columns);
					return;
				}
				
				String alert ="";
				for (ViolationDescription violationDescription : result)
					alert+="* "+violationDescription.getDescription()+"<br/>";
				
//				DialogResult box = new DialogResult(true, "Template Constraints Violations:", alert);
//
//				MessageBox.alert("Template Constraints Violations:", alert, null).show();
				
				DialogResult box = getDialog(TdTemplateAbstractResources.alerticon().createImage(), "Template Constraints Violations:", alert);
				box.show();
			}
		});
		
	}
	
	protected DialogResult getDialog(Image img, String title, String msg){
		
		DialogResult box = new DialogResult(img, title, msg);
		box.getElement().getStyle().setZIndex(getWindowZIndex()+1);
		box.center();
		return box;
		
	}

	protected List<TdColumnDefinition> getTdColumnDefintions(){
		
		List<ColumnDefinitionView> list = getTdGeneretor().getListColumnDefinition();

		List<TdColumnDefinition> columns = new ArrayList<TdColumnDefinition>(list.size());
		
		GWT.log("Column definitions size is: "+list.size());
		
		for (ColumnDefinitionView cDefView : list) {
			
			//ADDING RULES TODO MORE RULE NOW IS ONLY ONE
			/*List<TemplateExpression> rules = cDefView.getRulesExpression();
			C_Expression expression = null;
			if(rules!=null && rules.size()>0){
				//TODO FIRST RULE
				TemplateExpression templateExpression = rules.get(0);
				expression = templateExpression.getClientExpression();
			}*/
			
			TdTDataType dataType = cDefView.getSelectedDataType();
			
			//HAS IT A FORMAT REFERENCE?
			if(dataType.getFormatReferenceIndexer()!=null){
				dataType.setReference(cDefView.getSelectedDataTypeFormat());
			}
			
			TdColumnDefinition columnDefinition = new TdColumnDefinition(cDefView.getColumnIndex(), cDefView.getSelectedColumnCategory(), dataType, cDefView.getSpecialCategoryType());
			
			List<TemplateExpression> rules = cDefView.getRulesExpressions();
			
			GWT.log("RulesExpression is: "+rules);
			if(rules!=null && rules.size()>0){
				GWT.log("setting rules");
				columnDefinition.setRulesExtends(rules);
			}else
				GWT.log("rules is null or empty, skipping");
			
			if(cDefView.getSpecialCategoryType().equals(SPECIAL_CATEGORY_TYPE.NONE)){
//				if(cDefView.getRulesExpression()!=null){
//					columnDefinition.setRulesExtends(cDefView.getRulesExpression());
//				}
//				columnDefinition.setRuleExpression(expression);
			}else if(cDefView.getSpecialCategoryType().equals(SPECIAL_CATEGORY_TYPE.DIMENSION)){
				columnDefinition.setColumnData(cDefView.getReferenceColumnData());
			}else if(cDefView.getSpecialCategoryType().equals(SPECIAL_CATEGORY_TYPE.CODENAME)){
				columnDefinition.setLocale(cDefView.getSelectedLocale());
			}else if(cDefView.getSpecialCategoryType().equals(SPECIAL_CATEGORY_TYPE.TIMEDIMENSION)){
//				System.out.println("***TIMEPERIOD : "+cDefView.getTimePeriod());
				
				//TODO ADD MAP TIME VALUE
				Map<String, String> valueFormats = new HashMap<String, String>();
				valueFormats.put(cDefView.getTimePeriodFormat().getId(), ""); //the formatIdentifier
				
				GWT.log("Value Format : "+cDefView.getTimePeriodFormat() + ", to Time Period: "+cDefView.getTimePeriod());
				columnDefinition.setTimePeriod(new TdTTimePeriod(cDefView.getTimePeriod(),valueFormats));
			}
			
			columns.add(columnDefinition);
		}
		
		return columns;
	}
	
	/**
	 * 
	 */
	public TdTemplateController() {
		initController();
		loadLocales();
		laodTimePeriods();
	}
	
	
	/**
	 * 
	 */
	protected void loadLocales() {
		
		TdTemplateController.tdTemplateServiceAsync.getAllowedLocales(new AsyncCallback<List<String>>() {

			@Override
			public void onFailure(Throwable caught) {
				GWT.log("Error: "+caught.getMessage());
			}

			@Override
			public void onSuccess(List<String> result) {
				GWT.log("Allowed Locales loaded are: "+result.size());
				if (result != null){
					listLocales = result;
				}
				
			}
		});
	}
	
	
	private void laodTimePeriods(){
		
		TdTemplateController.tdTemplateServiceAsync.getTimeDimensionPeriodTypes(new AsyncCallback<List<TdTTimePeriod>>() {

			@Override
			public void onFailure(Throwable caught) {
				GWT.log("Error: "+caught.getMessage());
				
			}

			@Override
			public void onSuccess(List<TdTTimePeriod> result) {
				GWT.log("Loaded period types are: "+result.size());
				if (result != null){
					listPeriodTypes = result;
					
					for (TdTTimePeriod tdTTimePeriod : listPeriodTypes) {
						timeFormatsIndexer.put(tdTTimePeriod.getName(), tdTTimePeriod.getValueFormats());
					}
					
					printTimeFormats();
				}
			}
		});
	}
	
	private void printTimeFormats(){
		for (String key : timeFormatsIndexer.keySet()) {
			GWT.log("Key: "+key +" value: "+timeFormatsIndexer.get(key).toString());
		}
	}
	
	/**
	 * 
	 * @param periodTypeName
	 * @return
	 */
	public Map<String, String> getValueFormatsForPeriodTypeName(String periodTypeName){
		
//		GWT.log("getValueFormatsForPeriodTypeName for periodTypeName "+periodTypeName);
		return timeFormatsIndexer.get(periodTypeName);	
	}

	protected void initController(){
		
		initToolbarSubmit();
		binder = new TdTemplatePrivateEventsBinder();
		binder.bindEvents(this);
		bindCommonEvents();
		
		switcher = new TemplateFormSwitcherPanel();
		mainPanel.add(switcher);
//		window.layout();
		
		tdTemplateServiceAsync.getTemplateTypes(new AsyncCallback<List<TdTTemplateType>>() {
			
			@Override
			public void onSuccess(List<TdTTemplateType> result) {
				switcher.setTemplates(result);
			}
			
			@Override
			public void onFailure(Throwable caught) {
				GWT.log("An error occurred on recovering template types, "+caught.getMessage());
				displayError("Error", "Sorry an error occurred on contacting the service");
			}
		});
		
		
		tdTemplateServiceAsync.getOnErrorValues(new AsyncCallback<List<String>>() {

			@Override
			public void onFailure(Throwable caught) {
				GWT.log("An error occurred on recovering on errors, "+caught.getMessage());
				displayError("Error", "Sorry an error occurred on contacting the service");
			}

			@Override
			public void onSuccess(List<String> onErrors) {
				switcher.setOnErrors(onErrors);
				
			}
		});
	}
	
	public void displayError(String title, String error){
		MessageBox.alert("Error", error, null).show();
	}
	
	@Override
	public void doInitTemplate(TemplateSwitcherInteface switcherInterface) {
		switcher.mask("Creating template", TdTemplateConstants.LOADINGSTYLE);
//		System.out.println("templateType "+switcherInterface.getType());
//		System.out.println("numcol "+switcherInterface.getNumberOfColumns());
		tdGeneretor = new TemplateGenerator(switcherInterface, this);
		tdGeneretor.initTemplatePanel();
		
		initLocaleManager(switcherInterface);

//		switcher.hide();
		
		int index = mainPanel.indexOf(switcher);
		if(index!=-1)
			mainPanel.remove(switcher);
		
		mainPanel.mask("Building template");
		mainPanel.setLayout(new FitLayout());
		mainPanel.add(getTdGeneretor().getTemplatePanel().getPanel());
		mainPanel.layout(true);
		
		window.setHeading(TdTemplateConstants.TEMPLATECREATOR+": " +switcher.getName() +" - Type: "+switcherInterface.getType());
		mainPanel.unmask();
	}
	
	protected void initLocaleManager(TemplateSwitcherInteface switcherInterface){
		if(switcherInterface.getType().compareTo("CODELIST")==0){
			localeViewManager = new LocaleViewManager(listLocales, true);
		}else
			localeViewManager = new LocaleViewManager(listLocales, false);
	}
	
	
	/**
	 * Use for GXT 2.5
	 * @return
	 */
	public Window getWindowTemplatePanel() {
		
		window.setIcon(TdTemplateAbstractResources.newtemplate());
		window.setResizable(true);
		window.setAnimCollapse(true);
		window.setMaximizable(true);
		window.setHeading(TdTemplateConstants.TEMPLATECREATOR);
		window.setSize((width+20)+"px", (height+40)+"px");
		window.setLayout(new FitLayout());
		window.setBottomComponent(submitTool);
	    window.add(mainPanel);
	    window.setScrollMode(Scroll.AUTO);
//	    window.setZIndex(MAX_ZINDEX);
		return window;
	}
	
	protected void go(RootPanel rootPanel){
		
//		final DialogBox dialogBox = getDialogBoxTemplatePanel();
		final Window dialogBox = getWindowTemplatePanel();
		com.google.gwt.user.client.ui.Button openTemplateCreator = new com.google.gwt.user.client.ui.Button("Open Template Creator", new ClickHandler() {
	          public void onClick(ClickEvent event) {
	              dialogBox.show();
	          }
		    });
		rootPanel.add(openTemplateCreator);
	}

	public static EventBus getCommonBus() {
		return commonBus;
	}

	/**
	 * @return the tdGeneretor
	 */
	public static TemplateGenerator getTdGeneretor() {
		return tdGeneretor;
	}

	@Override
	public TemplateRuleHandler getTemplateRuleUpdater() {
		return templateRuleHandler;
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplate.client.TdTemplateControllerState#setExpressionDialogIndexUpdate(int)
	 */
	@Override
	public void setExpressionDialogIndexesUpdate(TemplateRuleHandler indexes) {
		templateRuleHandler = indexes;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplate.client.TdTemplateControllerState#doUpdateTemplate()
	 */
	@Override
	public void doUpdateTemplate() {

	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplate.client.TdTemplateControllerState#getSubmitTool()
	 */
	@Override
	public ToolBar getSubmitTool() {
		return submitTool;
	}

	public List<String> getAllowedLocales() {
		return listLocales;
	}

	public LocaleViewManager getLocaleViewManager() {
		return localeViewManager;
	}

	public List<TdTTimePeriod> getListPeriodTypes() {
		return listPeriodTypes;
	}



}
