/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.shared;

import java.io.Serializable;
import java.util.List;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Feb 5, 2014
 * 
 */
public class TdColumnDefinition implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 257447065800064772L;
	
	private int index;
	private TdTColumnCategory category;
	private TdTDataType dataType;

	/**
	 * Used to assign rule
	 */
//	private C_Expression ruleExpression;

	/**
	 * User client-side to handle special behavior
	 */
	private SPECIAL_CATEGORY_TYPE specialCategoryType;

	/**
	 * Used to set column reference
	 */
	private ColumnData columnData;

	private String locale;
	
	private TdTTimePeriod timePeriod;

	/**
	 * Used to assign rules
	 */
	private List<TemplateExpression> listExpressionExtend;

	/**
	 * 
	 */
	public TdColumnDefinition() {
	}
	
	

	/**
	 * Base constructor
	 * @param index
	 * @param category
	 * @param dataType
	 * @param type
	 */
	public TdColumnDefinition(int index, TdTColumnCategory category, TdTDataType dataType, SPECIAL_CATEGORY_TYPE type) {
		this.index = index;
		this.category = category;
		this.dataType = dataType;
		this.specialCategoryType = type;
	}
	

	public int getIndex() {
		return index;
	}

	public TdTColumnCategory getCategory() {
		return category;
	}

	public TdTDataType getDataType() {
		return dataType;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public void setCategory(TdTColumnCategory category) {
		this.category = category;
	}

	public void setDataType(TdTDataType dataType) {
		this.dataType = dataType;
	}

	
	/*public C_Expression getRuleExpression() {
		return ruleExpression;
	}
	
	
	public void setRuleExpression(C_Expression ruleExpression) {
		this.ruleExpression = ruleExpression;
	}*/

	public SPECIAL_CATEGORY_TYPE getSpecialCategoryType() {
		return specialCategoryType;
	}

	public ColumnData getColumnData() {
		return columnData;
	}
	
	public void setSpecialCategoryType(SPECIAL_CATEGORY_TYPE specialCategoryType) {
		this.specialCategoryType = specialCategoryType;
	}

	public void setColumnData(ColumnData columnData) {
		this.columnData = columnData;
	}


	/**
	 * @param selectedLocale
	 */
	public void setLocale(String selectedLocale) {
		this.locale = selectedLocale;
	}
	
	public String getLocale() {
		return locale;
	}

	/**
	 * @param timePeriod
	 */
	public void setTimePeriod(TdTTimePeriod timePeriod) {
//		this.timePeriod = timePeriod;
		this.timePeriod = timePeriod;
	}


	public TdTTimePeriod getTimePeriod() {
		return timePeriod;
	}

	/**
	 * @param listExpressionExtend
	 */
	public void setRulesExtends(List<TemplateExpression> listExpressionExtend) {
		this.listExpressionExtend = listExpressionExtend;
	}


	public List<TemplateExpression> getRulesExtends() {
		return listExpressionExtend;
	}



	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("TdColumnDefinition [index=");
		builder.append(index);
		builder.append(", category=");
		builder.append(category);
		builder.append(", dataType=");
		builder.append(dataType);
		builder.append(", specialCategoryType=");
		builder.append(specialCategoryType);
		builder.append(", columnData=");
		builder.append(columnData);
		builder.append(", locale=");
		builder.append(locale);
		builder.append(", timePeriod=");
		builder.append(timePeriod);
		builder.append(", listExpressionExtend=");
		builder.append(listExpressionExtend);
		builder.append("]");
		return builder.toString();
	}
	
}
