package org.gcube.portlets.user.tdtemplate.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.finals.AddToFlowAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.finals.DuplicateBehaviour;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.utils.FormatReference;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TemplateDescription;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;
import org.gcube.data.analysis.tabulardata.service.template.TemplateId;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.tdtemplate.client.rpc.TdTemplateService;
import org.gcube.portlets.user.tdtemplate.server.converter.ConverterToTdTemplateModel;
import org.gcube.portlets.user.tdtemplate.server.converter.ConverterToTemplateServiceModel;
import org.gcube.portlets.user.tdtemplate.server.service.TemplateService;
import org.gcube.portlets.user.tdtemplate.server.session.CacheServerExpressions;
import org.gcube.portlets.user.tdtemplate.server.session.SessionUtil;
import org.gcube.portlets.user.tdtemplate.server.validator.TemplateCategoryValidator;
import org.gcube.portlets.user.tdtemplate.server.validator.TemplateValidator;
import org.gcube.portlets.user.tdtemplate.server.validator.service.ColumnCategoryTemplateValidator;
import org.gcube.portlets.user.tdtemplate.shared.ClientReportTemplateSaved;
import org.gcube.portlets.user.tdtemplate.shared.TdBehaviourModel;
import org.gcube.portlets.user.tdtemplate.shared.TdColumnDefinition;
import org.gcube.portlets.user.tdtemplate.shared.TdFlowModel;
import org.gcube.portlets.user.tdtemplate.shared.TdLicenceModel;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTTemplateType;
import org.gcube.portlets.user.tdtemplate.shared.TdTTimePeriod;
import org.gcube.portlets.user.tdtemplate.shared.TdTemplateDefinition;
import org.gcube.portlets.user.tdtemplate.shared.TdTemplateUpdater;
import org.gcube.portlets.user.tdtemplate.shared.TemplateExpression;
import org.gcube.portlets.user.tdtemplate.shared.validator.ViolationDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class TdTemplateServiceImpl extends RemoteServiceServlet implements TdTemplateService {

	public static Logger logger = LoggerFactory.getLogger(TdTemplateServiceImpl.class);
	
//	public TdTemplateGxtObjectBuilder builder = new TdTemplateGxtObjectBuilder();
	/**
	 * 
	 * @return
	 */
	protected ASLSession getASLSession() {
		return SessionUtil.getAslSession(this.getThreadLocalRequest().getSession());
	}
	
	@Override
	public List<TdTColumnCategory> getColumnCategoryByTdTemplateDefinition(TdTemplateDefinition templateDefinition) throws Exception{
		
		try{
			
			TemplateCategory tmc = ConverterToTemplateServiceModel.templateCategoryFromTemplateName(templateDefinition.getTemplateType());
			logger.info("Putting template id "+templateDefinition.getServerId() +" in ASL session as type: "+templateDefinition.getTemplateType());
			SessionUtil.setTemplateDefinition(getASLSession(), templateDefinition);
			
			return ConverterToTdTemplateModel.getTdTColumnCategoryFromTemplateCategory(tmc);
		}catch (Exception e) {
			
			throw new Exception("Sorry an error occurred when contacting service, Try again later");
		}
	}
	
	@Override
	public List<TdTTemplateType> getTemplateTypes(){
		return ConverterToTdTemplateModel.getTdTTemplateTypeFromTemplateCategoryValues();
	}
	
	@Override
	public List<String> getOnErrorValues(){
		return ConverterToTdTemplateModel.getOnErrorValues();
	}
	
	
	@Override
	public List<TdTTimePeriod> getTimeDimensionPeriodTypes(){
		return ConverterToTdTemplateModel.getTimeDimensionPeriodTypes();
	}
	
	
	@Override
	public String getConstraintForTemplateType(TdTTemplateType type){
		
		return "";
	}
	
	
	@Override
	public ClientReportTemplateSaved submitTemplate(List<TdColumnDefinition> listColumns, TdFlowModel flowAttached) throws Exception{
		
		try{
			ServerReportTemplateSaved serverReport = getServerColumns(listColumns);
			
			List<TemplateColumn<? extends DataType>> columns = serverReport.getListConvertedColumn();
			
			logger.info("Converted Server Column are: "+columns.size());
			
			if(columns.size()>0){
				ASLSession session = getASLSession();
				TdTemplateDefinition templateDef = SessionUtil.getTemplateDefinition(session);
				
				logger.info("Retrieve template defitnition from ASL session: "+templateDef);
				
				TemplateCategory tmc = ConverterToTemplateServiceModel.templateCategoryFromTemplateName(templateDef.getTemplateType());
				logger.info("Converted in template category: "+tmc);
				
				// ON ROW ERROR ACTION
				OnRowErrorAction error = null;
				
				try{
					error = ConverterToTemplateServiceModel.onRowErrorAction(templateDef.getOnError());
				}catch (Exception e) {
					logger.error("Conversion of Row Error action: "+templateDef.getOnError() +", generated an exception, skipping ",e);
				}
				
				logger.info("Instancing Template service..");
				TemplateService service = new TemplateService(session.getScope(), session.getUsername());
				

				AddToFlowAction addToFlowAction = null;
				
				if(flowAttached!=null){
					logger.info("Converting flow..."+flowAttached);
					List<TabularResourceMetadata<?>> metadata = ConverterToTemplateServiceModel.convertFlow(flowAttached);
					TabularResource resource = service.createFlow(metadata);

					if(resource!=null){
						org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResource remoteResource = resource.getRemoteTabularResource();
						if(remoteResource!=null && flowAttached.getBehaviourId()!=null){
							try{
								DuplicateBehaviour duplicateBehaviour = ConverterToTemplateServiceModel.convertDuplicateBehaviour(flowAttached.getBehaviourId());
								addToFlowAction = ConverterToTemplateServiceModel.addToFlowAction(remoteResource, duplicateBehaviour);
								logger.info("AddToFlowAction created!");
							}catch(Exception e){
								logger.error(e.getMessage(),e);
							}
						}else{
							logger.warn("Remote resource flow or behaviour null, skipping AddToFlowAction");
						}
					}else
						logger.warn("Tabular resource flow is null, skipping AddToFlowAction");
				}
				
				
				Template template = TemplateService.generateTemplate(tmc, columns,error,addToFlowAction);
				String templateDescription = templateDef.getTemplateDescription() == null?"":templateDef.getTemplateDescription();
				String agency = templateDef.getAgency() == null?"":templateDef.getAgency(); 
				logger.info("Template generated!");

				
				logger.info("Saving template on service...");
				TemplateId templateId = service.saveTemplate(templateDef.getTemplateName(), templateDescription, agency, template);
				logger.info("Template saved on server with id: "+templateId.getValue());
				logger.info("ClientReportTemplateSaved contains errors? "+serverReport.getClientReport().isError());

			}else{
				logger.warn("Column size is 0, skipping template creation");
				throw new Exception("Sorry an error occurred on Template definition, Try again later");
			}
			
			return serverReport.getClientReport();
			
		}catch (Exception e) {
			logger.error("Template creation error: ",e);
			throw new Exception("Sorry an error occurred on Template creation, Try again later");
		}
	}
	
	
	
	@Override
	public ClientReportTemplateSaved updateTemplate(List<TdColumnDefinition> listColumns) throws Exception{
		
		try{
			logger.info("Updating Template...");
			ServerReportTemplateSaved serverReport = getServerColumns(listColumns);
			
			List<TemplateColumn<? extends DataType>> columns = serverReport.getListConvertedColumn();
			
			logger.info("Converted Server Column are: "+columns.size());
			
			if(columns.size()>0){
				ASLSession session = getASLSession();
				TdTemplateDefinition templateDef = SessionUtil.getTemplateDefinition(session);
				
				logger.info("Retrieve template defitnition from ASL session: "+templateDef);
				
				TemplateCategory tmc = ConverterToTemplateServiceModel.templateCategoryFromTemplateName(templateDef.getTemplateType());
				logger.info("Converted in template category: "+tmc);
				
				// ON ROW ERROR ACTION
				OnRowErrorAction error = null;
				
				try{
					error = ConverterToTemplateServiceModel.onRowErrorAction(templateDef.getOnError());
				}catch (Exception e) {
					logger.error("Conversion of Row Error action: "+templateDef.getOnError() +", generated an exception, skipping ", e);
				}
				
				Template template = TemplateService.generateTemplate(tmc, columns, error, null);
				
				Long serverId = templateDef.getServerId();
				logger.trace("Template for updating generated");
				
				if(serverId==null){
					throw new Exception("Template id not found");
				}
				
				//TODO MUST BE TESTED
				TemplateService service = new TemplateService(session.getScope(),session.getUsername());
				service.updateTemplate(serverId, template);
				logger.info("ClientReportTemplateSaved contains errors? "+serverReport.getClientReport().isError());

			}else{
				logger.warn("Column size is 0, skipping template creation");
				throw new Exception("Sorry an error occurred on Template definition, Try again later");
			}
			
			return serverReport.getClientReport();
			
		}catch (Exception e) {
			logger.error("Template updatating error: ",e);
			throw new Exception("Sorry an error occurred on Template creation, Try again later");
		}
	}
	
	
	protected ServerReportTemplateSaved getServerColumns(List<TdColumnDefinition> listColumns){
		
		List<TemplateColumn<? extends DataType>> columns = new ArrayList<TemplateColumn<? extends DataType>>();
		ClientReportTemplateSaved clientReport = new ClientReportTemplateSaved();
		
		for (TdColumnDefinition tdColumnDefinition : listColumns) {
			
			logger.info("Found TdColumnDefinition: "+tdColumnDefinition +", converting");
			
			try{
				ColumnCategory columnType = ConverterToTemplateServiceModel.tdTdTColumnCategoryToColumnCategory(tdColumnDefinition.getCategory());
				Class<? extends DataType> valueType = ConverterToTemplateServiceModel.tdTdTDataTypeToDataType(tdColumnDefinition.getDataType());

				TemplateColumn<? extends DataType> col = null;
				
				logger.info("SpecialCategoryType is: "+tdColumnDefinition.getSpecialCategoryType());
				logger.info("ColumnCategory as columnType is: "+columnType);
				logger.info("DataType as valueType is: "+valueType);
				
				
				switch (tdColumnDefinition.getSpecialCategoryType()) {
				case NONE:
					FormatReference reference = ConverterToTemplateServiceModel.tdTdTFormatRefereceToFormatReference(tdColumnDefinition.getDataType());
					col = TemplateService.createTemplateColumn(columnType, valueType, reference);
					logger.info("TemplateColumn converted: "+col);
					break;
					
				case TIMEDIMENSION:
					TdTTimePeriod timePeriod = tdColumnDefinition.getTimePeriod();
					logger.info("Read timePeriod: "+timePeriod);
					PeriodType period = ConverterToTemplateServiceModel.periodNameToPeriodType(timePeriod.getName());
					logger.info("PeriodType is: "+period);
					
					Map<String, String> valuesFormat = timePeriod.getValueFormats(); 

					if(valuesFormat==null || valuesFormat.size()==0){
						logger.error("ValueFormat not found for PeriodType: "+period +" skypping column");
						break;
					}
					
					String formatIdentifier = null;
					for (String key : valuesFormat.keySet()) {
						formatIdentifier = key; 
						break; //MUST ONLY ONE
					}
					
					logger.info("formatIdentifier: "+formatIdentifier);

					
					//TODO ADD VALUE FORMAT???
					col = TemplateService.createTemplateColumnForTimeDimension(columnType, valueType, period, formatIdentifier);
					logger.info("TemplateColumn for TimeDimension converted: "+col);
					break;

				case DIMENSION:
					ColumnData cdata = tdColumnDefinition.getColumnData();
					logger.info("Read cdata: "+cdata);
					col = TemplateService.createTemplateColumnForDimension(columnType, valueType, Integer.parseInt(cdata.getTrId().getTableId()), cdata.getColumnId());
					logger.info("TemplateColumn for Dimension converted: "+col);
					break;
					
				case CODENAME:
					String locale = tdColumnDefinition.getLocale();
					logger.info("Read locale: "+locale);
					col = TemplateService.createTemplateColumnForCodeName(valueType, locale);
					logger.info("TemplateColumn for CodeName converted: "+col);
					
				default:
					break;
				}
				
//				TemplateColumn<? extends DataType> col = TemplateService.createTemplateColumn(columnType, valueType);
//				logger.trace("TemplateColumn created: "+col);
				
				if(col!=null){
				
					//ADDING EXPRESSION
					List<TemplateExpression> rules = tdColumnDefinition.getRulesExtends();
					logger.info("Converting rules expressions: "+rules);
					List<Expression> expressions = null;
					if(rules!=null && rules.size()>0){
						expressions = new ArrayList<Expression>(rules.size());
						
						CacheServerExpressions cachedExpressions = SessionUtil.getCacheExpression(getASLSession());
						for (TemplateExpression templateExpression : rules) {
							Expression expression = null;
							if(templateExpression.getClientExpression()!=null){
								logger.info("is client expression, now converting");
								expression = ConverterToTemplateServiceModel.convertRuleExpression(templateExpression.getClientExpression());
								expressions.add(expression);
							}else if(templateExpression.getServerExpression()!=null){
								logger.info("is server expression, now converting");
								expression = cachedExpressions.getExpression(templateExpression.getServerExpression());
								if(expression!=null){
									logger.info("server expression is cached, adding to column: "+expression);
									expressions.add(expression);
								}else
									logger.info("server expression is not cached, skipping");
							}	
						}
			
						for (Expression expression : expressions) {
							logger.info("Adding expression: "+expression);
							col.addExpression(expression);
						}
					}
					
					columns.add(col);
				}else{
					
					clientReport.setError(true);
					clientReport.addColumnError(tdColumnDefinition);
					logger.warn("Conversion of TdColumnDefinition: "+tdColumnDefinition +", has generate column null, skipping");
				}
				
			}catch (Exception e) {
				clientReport.setError(true);
				clientReport.addColumnError(tdColumnDefinition);
				logger.error("Exception on Conversion of TdColumnDefinition: "+tdColumnDefinition +", skipping", e);
			}
		}
		return new ServerReportTemplateSaved(clientReport, columns);
//		return columns;
		
	}
	
	@Override
	/**
	 * NOT USED
	 */
	public List<ColumnData> resolveColumnForDimension(TRId trId) throws Exception{
		/*TDGWTServiceImpl tDGWTServiceImpl = new TDGWTServiceImpl();

		try {
			List<ColumnData> listColumnsData = tDGWTServiceImpl.getColumnsForDimension(trId);
			
			return listColumnsData;
		} catch (TDGWTServiceException e) {
			logger.error("ResolveColumnForDimension error",e);
			throw new Exception("Sorry an error occurred on resolving CodeList column, Try again later");
		}
		*/
		return null;
		
	}

	@Override
	public TdTemplateUpdater getTemplateUpdaterForTemplateId(long templateId) throws Exception{
		logger.info("getTemplateUpdaterForTemplateId for id "+templateId);
		ASLSession session = getASLSession();
		TemplateService service = new TemplateService(session.getScope(), session.getUsername());
	
		try{
			TemplateDescription templateDescr = service.getTemplate(templateId);
			if(templateDescr==null)
				throw new Exception("Sorry, an error occurred on recovering template with id "+templateId + " not exists");
		
			logger.info("Invalidate old cache expressions");
			SessionUtil.setCacheExpression(session, null);
			
//			if(cache==null){
//				logger.info("Cache server exception is null, creating");
//				cache = new CacheServerExpressions();
//			}
			
			logger.info("Creating new cache expression");
			CacheServerExpressions cache = new CacheServerExpressions();
	
			TemplateUpdaterForDescription updaterDescription = ConverterToTdTemplateModel.getTdTemplateUpdaterFromTemplateDescription(templateDescr,service, cache);

			logger.info("Cache server updating");
			SessionUtil.setCacheExpression(session, updaterDescription.getCache());
			
			return updaterDescription.getTdUpdater();
		
		}catch (Exception e) {
			logger.error("GetTemplateUpdaterForTemplateId error",e);
			throw new Exception("Sorry, an error occurred on recovering template with id "+templateId);
		}
	}
	
	@Override
	public List<String> getAllowedLocales(){
		return ConverterToTdTemplateModel.getAllowedLocales();
	}
	
	
	@Override
	public boolean isValidTemplate(List<TdTColumnCategory> columns) throws Exception{
		logger.info("Validating template.., column size is: "+columns.size());
		
		ASLSession session = getASLSession();
		TdTemplateDefinition templateDef = SessionUtil.getTemplateDefinition(session);
		if(templateDef==null)
			throw new Exception("Sorry an error occurred on recovering template definition from session");
		
		TemplateCategoryValidator templateValidator = null;
		
		if(templateDef.getTemplateType().compareToIgnoreCase(TemplateCategory.CODELIST.toString())==0){
			 templateValidator = new ColumnCategoryTemplateValidator(TemplateCategory.CODELIST);
		}else if(templateDef.getTemplateType().compareToIgnoreCase(TemplateCategory.DATASET.toString())==0){
			templateValidator = new ColumnCategoryTemplateValidator(TemplateCategory.DATASET);
		}if(templateDef.getTemplateType().compareToIgnoreCase(TemplateCategory.GENERIC.toString())==0){
			templateValidator = new ColumnCategoryTemplateValidator(TemplateCategory.GENERIC);
//			logger.info("Current template is  TemplateCategory.DATASET, there are not constraints, skipping validation");
		}
		
		if(templateValidator!=null){
			TemplateValidator validator = new TemplateValidator(columns, templateValidator);
			validator.validate();
			SessionUtil.setConstraintsViolations(session, validator.getViolations());
			logger.info("Returning violations size: "+validator.getViolations().size());
			return (validator.getViolations().size()==0);
		}
		
		return true;
	
	}
	
	@Override
	public List<ViolationDescription> getTemplateConstraintsViolations(){
		
		ASLSession session = getASLSession();
		List<ViolationDescription> violations = SessionUtil.getConstraintsViolations(session);
		logger.info("Found List<ViolationDescription>: "+violations +", returning");
		return violations;
	}
	

	@Override
	public String getTemplateHelper() {
		return new TemplateHelper().getBuilderHTML().toString();
	}
	
	/**
	 * 
	 */
	@Override
	public List<TdLicenceModel> getLicences() throws Exception {
		try {
			List<TdLicenceModel> licences = ConverterToTdTemplateModel.getLicences();
			logger.trace("Licences: " + licences.size());
			return licences;
		}catch (Exception e) {
			logger.error("Licence error",e);
			throw new Exception("Sorry, an error occurred on recovering licence");
		}

	}
	
	@Override
	public List<TdBehaviourModel> getBehaviours() throws Exception {
		try {
			List<TdBehaviourModel> behaviour = ConverterToTdTemplateModel.getDuplicateBehaviours();
			logger.trace("DuplicateBehaviour: " + behaviour.size());
			return behaviour;
		}catch (Exception e) {
			logger.error("Licence error",e);
			throw new Exception("Sorry, an error occurred on recovering licence");
		}

	}
	
	@Override
	public TdFlowModel getFlowByTemplateId(long templateId) throws Exception{
		logger.info("getFlowByTemplateId for id "+templateId);
		ASLSession session = getASLSession();
		TemplateService service = new TemplateService(session.getScope(), session.getUsername());
		
		try{
			
			AddToFlowAction flow = service.getFlowByTemplateId(templateId);
			
			if(flow!=null){
				logger.info("AddToFlowAction is not null for template id:" +templateId);
				Collection<TabularResourceMetadata<?>> listMetadata = service.getFlowMetadataByTemplateFlowAction(flow);
				
				TdBehaviourModel bhvModel = ConverterToTdTemplateModel.convertDuplicateBehaviour(flow.getDuplicatesBehaviuor());
			
				TdFlowModel flowModel = ConverterToTdTemplateModel.convertFlow(listMetadata);
				
				flowModel.setBehaviourId(bhvModel.getId());
				
				return flowModel;
			}
			logger.info("AddToFlowAction is null for template id: " +templateId +", returning null");
			return null;
		}catch (Exception e) {
			logger.error("getFlowByTemplateId error",e);
			throw new Exception("Sorry, an error occurred on recovering flow for template with id "+templateId);
		}
	}
	/*
	public static void main(String[] args) throws Exception {
		
		String user = "francesco.mangiacrapa";
		String scope = "/gcube/devsec/devVRE"; //Development
		long templateID = 3;
		TemplateService service = new TemplateService(scope, user);
		
		try{
			
			AddToFlowAction flow = service.getFlowByTemplateId(templateID);
			
			Collection<TabularResourceMetadata<?>> listMetadata = service.getFlowMetadataByTemplateFlowAction(flow);
			
			TdBehaviourModel bhvModel = ConverterToTdTemplateModel.convertDuplicateBehaviour(flow.getDuplicatesBehaviuor());
		
			TdFlowModel flowModel = ConverterToTdTemplateModel.convertFlow(listMetadata);
			
			flowModel.setBehaviourId(bhvModel.getId());
			
			System.out.println(flowModel);
		
		}catch (Exception e) {
			logger.error("getFlowByTemplateId error",e);
			throw new Exception("Sorry, an error occurred on recovering flow for template with id "+templateID);
		}
		
	}*/
}
