/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template.view.external;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.core.shared.GWT;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @May 5, 2014
 *
 */
public class ExpressionsDialogMng {
	
	private int columnIndex;
	private Map<String, ExpressionDialogCaller> mapCallers = new HashMap<String, ExpressionDialogCaller>();
	private String columnId;
	
	/**
	 * 
	 */
	public ExpressionsDialogMng(String columnId, int columnIndex) {
		this.columnIndex = columnIndex;
		this.columnId = columnId;
	}
	
	

	public int getColumnIndex() {
		return columnIndex;
	}
	
	/**
	 * 
	 * @param columnType
	 * @param dataType
	 * @return the index of the ExpressionDialogCaller added
	 * @throws Exception
	 */
	public void updateExpressionCaller(String columnType, String dataType, int expressionIndex) throws Exception{
		String key = getKey(expressionIndex);
		mapCallers.put(key, new ExpressionDialogCaller(columnId, columnType, dataType));
	}
	
	private String getKey(int expressionIndex){
		return columnId+"Expression"+expressionIndex;
	}
	
	/**
	 * 
	 * @return
	 */
	public int size(){
		return mapCallers.size();
	}
	
	/**
	 * 
	 * @param columnIndex
	 * @return
	 * @throws Exception
	 */
	public boolean deleteExpressionCaller(int expressionIndex) {
		GWT.log("Deleting expression caller at index "+expressionIndex);
		ExpressionDialogCaller exp = null;
		try {
			validateKey(expressionIndex);
			String key = getKey(expressionIndex);
			exp = mapCallers.remove(key);
		} catch (Exception e) {
			GWT.log("Expression index is out of range, skipping delete expression caller");
			return false;
		}
		
		
		return exp!=null?true:false;
	}
	
	public ExpressionDialogCaller getEDCaller(int expressionIndex) throws Exception{
		GWT.log("Get Caller expression at index "+expressionIndex);
		try {
			validateKey(expressionIndex);
			String key = getKey(expressionIndex);
			return 	mapCallers.get(key);
		} catch (Exception e) {
			GWT.log("Expression index is out of range, skipping get expression caller");
			return null;
		}
	}
	
	private void validateKey(int index) throws Exception{
		String key = getKey(index);
		GWT.log("Validating key: "+key);
		if(mapCallers.get(key)==null)
			throw new Exception("ExpressionDialogCaller with index: "+index +" doesn't exists");
		
		GWT.log("Key is ok, the caller exists");
	}

	public String getColumnId() {
		return columnId;
	}

}
