/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template.flow;

import java.util.ArrayList;

import org.gcube.portlets.user.td.expressionwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.licenses.LicenceData;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateConstants;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.core.XDOM;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox.TriggerAction;
import com.extjs.gxt.ui.client.widget.form.DateField;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Oct 16, 2014
 *
 */
public class FlowCreatePanel extends LayoutContainer {

	protected SimpleComboBox<String> comboLicense = new SimpleComboBox<String>();
	protected TextField<String> name = new TextField<String>();
	protected TextArea description = new TextArea();
	protected TextField<String> agency = new TextField<String>();
	protected TextField<String> rights = new TextField<String>();
	
	private FormData formData = new FormData("-20");  
	protected Button buttonCreateFlow = new Button("Create Flow");
	
	private HorizontalPanel hp;
	private FormPanel formPanel = new FormPanel();
	private FlowCreatePanel instance = this;
	
	private Long serverId = null;

	private DateField toDate;
	private DateField fromDate;
	
	private boolean flowCreated = false;
	
	  @Override  
	  protected void onRender(Element parent, int index) {  
	    super.onRender(parent, index);  
//	    formData = new FormData("-10");  
	    hp = new HorizontalPanel();
//	    vp.setLayout(new FitLayout());
		int width = TdTemplateConstants.MAINWIDTH-20;
		int height = TdTemplateConstants.MAINHEIGHT-40;
		hp.setSize(width, height);
		formPanel.setWidth(390);
		hp.add(formPanel);
	    hp.setStyleAttribute("padding", "10px");
	    add(hp);  
	  }  
	  
	  
	
	public FlowCreatePanel(WindowFlowCreate windowFlowCreate) {
		formPanel.setHeaderVisible(false);
	    formPanel.setFrame(false);  
//	    formPanel.setWidth(350); 

	    initComboLicense(false);
		initListeners();

		name.setFieldLabel("Name");
		name.setAllowBlank(false);
		formPanel.add(name, formData);
		
		agency.setFieldLabel("Agency");
		agency.setAllowBlank(true);
		formPanel.add(agency,formData);
		
		description.setFieldLabel("Description");
		description.setAllowBlank(true);
		formPanel.add(description,formData);
		
		ComponentPlugin plugin = new ComponentPlugin() {  
	      public void init(Component component) {  
	        component.addListener(Events.Render, new Listener<ComponentEvent>() {  
	          public void handleEvent(ComponentEvent be) {  
	            El elem = be.getComponent().el().findParent(".x-form-element", 3);  
	            // should style in external CSS  rather than directly  
	            elem.appendChild(XDOM.create("<div style='color: #615f5f;padding: 1 0 2 0px;'>" + be.getComponent().getData("text") + "</div>"));  
	          }  
	        });  
	      }  
	    };  
		
		fromDate = new DateField();  
		fromDate.setFieldLabel("Valid From");  
		fromDate.addPlugin(plugin);  
		fromDate.setData("text", "Enter valid from");  
		formPanel.add(fromDate, formData);  
	    
	    toDate = new DateField();
	    toDate.setFieldLabel("Valid Until To");  
	    toDate.addPlugin(plugin);  
	    toDate.setData("text", "Enter valid until to");  
	    formPanel.add(toDate, formData);  
	    
		fromDate.addListener(Events.Change, new Listener<FieldEvent>() {

			@Override
			public void handleEvent(FieldEvent be) {

				if(fromDate.isValid())
					toDate.setMinValue(fromDate.getValue());
				else{
//					toDate.reset();
					toDate.getDatePicker().clearState();
				}
			}
        });
		
		toDate.addListener(Events.Change, new Listener<FieldEvent>() {

			@Override
			public void handleEvent(FieldEvent be) {

				if(toDate.isValid()){
					fromDate.setMaxValue(toDate.getValue());
				}
				else{
//					fromDate.reset();
					fromDate.getDatePicker().clearState();
				}
			}
        });


	    formPanel.add(comboLicense, formData);
	   
	    formPanel.add(buttonCreateFlow);
	    formPanel.setButtonAlign(HorizontalAlignment.CENTER);
	    
	    FormButtonBinding binding = new FormButtonBinding(formPanel);  
	    binding.addButton(buttonCreateFlow);  
	}

	/**
	 * 
	 */
	private void initComboLicense(boolean enabled) {
		
		comboLicense.setFieldLabel("License");
		comboLicense.setEditable(false);
		comboLicense.setTriggerAction(TriggerAction.ALL);
		comboLicense.setEmptyText("Choose License");
		comboLicense.setAllowBlank(false);
		comboLicense.setEnabled(enabled);
		
		TDGWTServiceAsync.INSTANCE.getLicences(new AsyncCallback<ArrayList<LicenceData>>() {

			public void onFailure(Throwable caught) {
				if (caught instanceof TDGWTSessionExpiredException) {
					TdTemplateController.getCommonBus().fireEvent(new SessionExpiredEvent(
							SessionExpiredType.EXPIREDONSERVER));
				} else {
					UtilsGXT3.alert("Error","Error retrieving licences.");
				}

			}

			public void onSuccess(ArrayList<LicenceData> result) {
//				Log.trace("loaded " + result.size() + " LicenceData");
				
				for (LicenceData licenceData : result) {
					comboLicense.add(licenceData.getLicence());
					comboLicense.setData(licenceData.getId()+"", licenceData.getLicence());
				}
				
				comboLicense.setEnabled(true);
			}

		});
	}
	
	

	protected void initListeners() {
		
		buttonCreateFlow.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {
				
				try{
					if(isValidForm())
						flowCreated = true;
					else
						flowCreated = false;
					
				}catch (Exception e) {
					e.printStackTrace();
				}
					
			}
		});
		
	}

	public boolean isValidForm(){
		
		if(name.isValid() && comboLicense.isValid()){
			
			try{

			}catch (NumberFormatException e) {
				MessageBox.alert("Error", "The field 'Number of Columns' is not an integer", null).show();
				return false;
			}catch (Exception e) {
				MessageBox.alert("Error", e.getMessage(), null).show();
				return false;
			}
			
			return true;
		}
		
		return false;
		
	}
	
	public String getLicense(){
		
		if(comboLicense.getSelection().size()>0)
			return comboLicense.getSelection().get(0).getValue();
		
		return null;
	}
	


	public String getName(){
		return name.getValue();
	}
	

	public String getDescription(){
		return description.getValue();
	}
	
	public String getAgency() {
		return agency.getValue();
	}
}
