/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.server.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.utils.LocaleReference;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.Locales;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.portlets.user.td.expressionwidget.server.C_ExpressionParser;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.tdtemplate.shared.TdTColumnCategory;
import org.gcube.portlets.user.tdtemplate.shared.TdTDataType;
import org.gcube.portlets.user.tdtemplate.shared.TdTTemplateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 27, 2014
 *
 */
public class ConverterToTemplateServiceModel {
	

	public static Logger logger = LoggerFactory.getLogger(ConverterToTemplateServiceModel.class);
	
	/**
	 * 
	 * @param tdtColumnCategory
	 * @return
	 * @throws Exception
	 */
	public static ColumnCategory tdTdTColumnCategoryToColumnCategory(TdTColumnCategory tdtColumnCategory) throws Exception{
		
		if(tdtColumnCategory==null)
			throw new Exception("ColumnCategory is null");
		
		String id = tdtColumnCategory.getId();
		
		if(id==null || id.isEmpty())
			throw new Exception("ColumnCategory ID is null");
		
		
		try{
			return ColumnCategory.valueOf(tdtColumnCategory.getId());
			
		}catch (Exception e) {
			throw new Exception("ColumnCategory ID "+ tdtColumnCategory.getId()+" is not a "+ColumnCategory.class);
		}
		
	}
	
	/**
	 * 
	 * @param templateName
	 * @return
	 * @throws Exception
	 */
	public static TemplateCategory templateCategoryFromTemplateName(String templateName) throws Exception{
		
		try{
			return TemplateCategory.valueOf(templateName);
			
		}catch (Exception e) {
			throw new Exception("The Name "+ templateName+" is not a value of "+TemplateCategory.class);
		}
		
	}
	

	/**
	 * 
	 * @param periodName
	 * @return
	 * @throws Exception
	 */
	public static PeriodType periodNameToPeriodType(String periodName) throws Exception{
		
		try{
			return PeriodType.valueOf(periodName);
			
		}catch (Exception e) {
			throw new Exception("The PeriodType "+ periodName+" is not a value of "+PeriodType.class);
		}
		
	}
	
	
	/**
	 * 
	 * @param localeId
	 * @return
	 */
	public static LocaleReference localeIdToLacaleReference(String localeId){
		
		if(localeId==null || localeId.isEmpty())
			return  new LocaleReference(Locales.getDefaultLocale());
		
		logger.info("Founding locale for: "+localeId);

		 List<String> list = new ArrayList<String>(Arrays.asList(Locales.ALLOWED_LOCALES));
		 
		 int index = list.indexOf(localeId);
		 
		 logger.info("Locale index is: "+index);
		 
		 if(index >= 0)
			 return new LocaleReference(list.get(index));
		 
		 return new LocaleReference(Locales.getDefaultLocale());
	}
	
	/**
	 * 
	 * @param columnCategoryName
	 * @return
	 * @throws Exception
	 */
	public static TemplateCategory templateCategoryFromColumnCategoryName(String columnCategoryName) throws Exception{
		
		try{
			return TemplateCategory.valueOf(columnCategoryName);
			
		}catch (Exception e) {
			throw new Exception("The Name "+ columnCategoryName+" is not a value of "+TemplateCategory.class);
		}
		
	}
	
	/**
	 * 
	 * @param templateType
	 * @return
	 * @throws Exception
	 */
	public static TemplateCategory tdTemplateTypeToTemplateCategory(TdTTemplateType templateType) throws Exception{
		
		if(templateType==null)
			throw new Exception("TdTTemplateType is null");
		
		String id = templateType.getId();
		
		if(id==null || id.isEmpty())
			throw new Exception("TdTTemplateType ID is null");
		
		
		try{
			return templateCategoryFromTemplateName(templateType.getId());
			
		}catch (Exception e) {
			throw new Exception("TdTTemplateType ID "+ templateType.getId()+" is not a "+TemplateCategory.class);
		}
		
	}
	
	public static Class<? extends DataType> tdTdTDataTypeToDataType(TdTDataType tdTdTDataType) throws Exception{
		
		if(tdTdTDataType==null)
			throw new Exception("TdTDataType is null");
		
		if(tdTdTDataType.getId().compareTo(NumericType.class.getName())==0)
			return NumericType.class;
		else if(tdTdTDataType.getId().compareTo(TextType.class.getName())==0)
			return TextType.class;
		else if(tdTdTDataType.getId().compareTo(BooleanType.class.getName())==0)
			return BooleanType.class;
		else if(tdTdTDataType.getId().compareTo(DateType.class.getName())==0)
			return DateType.class;
		else if(tdTdTDataType.getId().compareTo(GeometryType.class.getName())==0)
			return GeometryType.class;
		else if(tdTdTDataType.getId().compareTo(IntegerType.class.getName())==0)
			return IntegerType.class;
		
		return null;
	}
	
	/**
	 * 
	 * @param columnCategoryName
	 * @return
	 * @throws Exception
	 */
	public static OnRowErrorAction onRowErrorAction(String error) throws Exception{
		
		try{
			return OnRowErrorAction.valueOf(error);
			
		}catch (Exception e) {
			throw new Exception("The Error "+ error+" is not a value of "+OnRowErrorAction.class);
		}
		
	}
	
	
	/**
	 * 
	 * @param columnCategoryName
	 * @return
	 * @throws Exception
	 */
	public static Expression convertRuleExpression(C_Expression expr) throws Exception{
		C_ExpressionParser parser = new C_ExpressionParser();
		try{
			logger.info("Converting C_Expression.."+expr);
			return parser.parse(expr);
			
		}catch (Exception e) {
			throw new Exception("C_ExpressionParser generated an error: ", e);
		}
		
	}
	

}
