/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.server;

import java.util.List;

import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.portlets.user.tdtemplate.shared.ClientReportTemplateSaved;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Apr 4, 2014
 *
 */
public class ServerReportTemplateSaved {


	private ClientReportTemplateSaved clientReport;
	
	private List<TemplateColumn<? extends DataType>> listConvertedColumn;


	/**
	 * @param clientReport
	 * @param listConvertedColumn
	 */
	public ServerReportTemplateSaved(ClientReportTemplateSaved clientReport, List<TemplateColumn<? extends DataType>> listConvertedColumn) {
		this.clientReport = clientReport;
		this.listConvertedColumn = listConvertedColumn;
	}

	
	public ClientReportTemplateSaved getClientReport() {
		return clientReport;
	}

	public List<TemplateColumn<? extends DataType>> getListConvertedColumn() {
		return listConvertedColumn;
	}

	public void setClientReport(ClientReportTemplateSaved clientReport) {
		this.clientReport = clientReport;
	}

	public void setListConvertedColumn(
			List<TemplateColumn<? extends DataType>> listConvertedColumn) {
		this.listConvertedColumn = listConvertedColumn;
	}


	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ServerReportTemplateSaved [clientReport=");
		builder.append(clientReport);
		builder.append(", listConvertedColumn=");
		builder.append(listConvertedColumn);
		builder.append("]");
		return builder.toString();
	}

	
}
