/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template;

import java.util.ArrayList;
import java.util.List;

import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.google.gwt.core.shared.GWT;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 30, 2014
 * 
 */
public class SetTypeColumnContainer extends LayoutContainer {

	/**
	 * 
	 */
	private static final int COMBO_WIDTH = 110;
	private SimpleComboBox<String> sbc1;
	private SimpleComboBox<String> sbc2;
	private VerticalPanel vp = new VerticalPanel();		
	
	private List<SimpleComboBox<String>> listSCB = new ArrayList<SimpleComboBox<String>>();

	public SetTypeColumnContainer(SimpleComboBox<String> scbCategory, SimpleComboBox<String> scbDataType) {

		this.sbc1 = scbCategory;
		this.sbc2 = scbDataType;

		this.setStyleAttribute("padding", "2px");
		sbc1.setStyleAttribute("margin-bottom", "2px");
		sbc1.setWidth(COMBO_WIDTH);
		sbc2.setWidth(110);
		vp.add(sbc1);
		vp.add(sbc2);
		
		add(vp);
	}

	/**
	 * 
	 * @return is valid form if all combo added to panel are not empty
	 */
	public boolean isValidForm() {
		
		for (SimpleComboBox<String> scb : listSCB) {
			if (scb.getSimpleValue().isEmpty())
				return false;
		}
		
		return true;
	}
	
	public void addCombo(SimpleComboBox<String> sbc){
		listSCB.add(sbc);
		sbc.setWidth(110);
		vp.add(sbc);
		vp.layout();
		this.layout(true);
	}
	
	public void removeCombo(SimpleComboBox<String> sbc){
		
		if(listSCB.remove(sbc)){
			GWT.log("Removed combo");
			try{
				vp.remove(sbc);
			}catch (Exception e) {
				System.out.println("Combo dosn't exists");
			}
		this.layout(true);
		}

	}
}
