/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template.view.external;

import org.gcube.portlets.user.td.expressionwidget.client.ColumnExpressionDialog;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;
import org.gcube.portlets.user.tdtemplate.shared.util.CutStringUtil;

import com.google.web.bindery.event.shared.EventBus;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Mar 11, 2014
 *
 */
public class ExpressionDialogMng {
	
	private String columnId;
	private String columnType;
	private String dataType;
	private ColumnTypeCode columnTypeCode;
	private ColumnDataType columnDataType;
	private ColumnExpressionDialog expressionDialog;

	/**
	 * @throws Exception 
	 * 
	 */
	public ExpressionDialogMng(String columnId, String columnType, String dataType) throws Exception {
		converColumn(columnId, columnType, dataType);
		this.expressionDialog = new ColumnExpressionDialog(columnId,columnTypeCode, columnDataType, TdTemplateController.getCommonBus());
	}
	
	private void converColumn(String columnId, String columnType, String dataType) throws Exception{
		this.columnId = columnId;
		this.columnType = columnType;
		
		if(this.columnId==null || this.columnId.isEmpty())
			throw new Exception("An error occurred on instancing Expression Dialog, invalid column id parameter");
		
		if(this.columnType==null || this.columnType.isEmpty())
			throw new Exception("An error occurred on instancing Expression Dialog, invalid column id parameter");
		
		//REMOVE SUFFIX "Type" or "type" if exists
		this.dataType = CutStringUtil.stringPurgeSuffix(dataType, "Type");
		this.dataType = CutStringUtil.stringPurgeSuffix(this.dataType, "type");
		

		this.columnTypeCode = ExpressionDialogConvertUtil.toColumnTypeCode(this.columnType);
		this.columnDataType = ExpressionDialogConvertUtil.toColumnDataType(this.dataType);

		if(this.columnTypeCode==null || this.columnDataType==null)
			throw new Exception("An error occurred on instancing Expression Dialog, invalid parameter, Please refresh and try again");
	}
	
	/**
	 * @throws Exception 
	 * 
	 */
	public ExpressionDialogMng(String columnId, String columnType, String dataType, EventBus bus) throws Exception {
		converColumn(columnId, columnType, dataType);
		this.expressionDialog = new ColumnExpressionDialog(columnId,columnTypeCode, columnDataType, bus);
	}
	

	public String getColumnId() {
		return columnId;
	}

	public String getColumnType() {
		return columnType;
	}

	public String getDataType() {
		return dataType;
	}

	public ColumnTypeCode getColumnTypeCode() {
		return columnTypeCode;
	}

	public ColumnDataType getColumnDataType() {
		return columnDataType;
	}

	public ColumnExpressionDialog getExpressionDialog() {
		return expressionDialog;
	}
	
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ExpressionDialogMng [columnId=");
		builder.append(columnId);
		builder.append(", columnType=");
		builder.append(columnType);
		builder.append(", dataType=");
		builder.append(dataType);
		builder.append(", columnTypeCode=");
		builder.append(columnTypeCode);
		builder.append(", columnDataType=");
		builder.append(columnDataType);
		builder.append("]");
		return builder.toString();
	}
	
	public static void main(String[] args) {
		try {
			System.out.println(new ExpressionDialogMng("2", "CODENAME", "DateType"));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
