/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template.view;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.tdtemplate.client.TdTemplateConstants;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;
import org.gcube.portlets.user.tdtemplate.client.event.SetColumnTypeCompletedEvent;
import org.gcube.portlets.user.tdtemplate.client.event.TemplateComplitedEvent;
import org.gcube.portlets.user.tdtemplate.client.resources.TdTemplateAbstractResources;
import org.gcube.portlets.user.tdtemplate.client.template.SetColumnTypeDefinition;
import org.gcube.portlets.user.tdtemplate.client.template.SetColumnTypeDialogManager;
import org.gcube.portlets.user.tdtemplate.client.template.view.suggestion.ConstraintSuggestionLabel;
import org.gcube.portlets.user.tdtemplate.client.template.view.suggestion.SuggestionContainer;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.Style.IconAlign;
import com.extjs.gxt.ui.client.Style.LayoutRegion;
import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.menu.SeparatorMenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 8, 2014
 *
 */
public class TemplatePanel {
	
	protected FlexTable flexTableTemplate = new FlexTable();
	protected LayoutContainer flexTableContainer = new LayoutContainer();
	private int numColumns;
	protected ContentPanel tableContainer = new ContentPanel();
	private SuggestionContainer suggestionContainer = new SuggestionContainer();
	
	protected List<ColumnDefinitionView> columnsDefined;
	private TemplateSwitcherInteface templateSwitcherInteface;
	protected SetColumnTypeDefinition setColumnTypeDefinition;
	protected TdTemplateController controller;
	
	private LayoutContainer centralContainer = new LayoutContainer();
	
	protected ContentPanel principalContainer;
	protected ContentPanel southContainer;
//	protected Button filterBySelection;
	private BorderLayout borderLayout;
	private BorderLayoutData centerData;
	private BorderLayoutData southData;
	
	
	/**
	 * @param setColumnTypeDefinition 
	 * 
	 */
	public TemplatePanel(TemplateSwitcherInteface templateSwitcherInteface, TdTemplateController controller) {
		this.numColumns = templateSwitcherInteface.getNumberOfColumns();
		this.controller = controller;
		this.templateSwitcherInteface = templateSwitcherInteface;
		this.columnsDefined = new ArrayList<ColumnDefinitionView>(numColumns);
	
		setColumnTypeDefinition = new SetColumnTypeDefinition(templateSwitcherInteface) {
			
			@Override
			public void updateListCategory() {
				GWT.log("Init table");
				tableContainer.setEnabled(true);
				initTableColumns(flexTableTemplate, 0, numColumns);
				TdTemplateController.getInternalBus().fireEvent(new SetColumnTypeCompletedEvent());
			}
		};
		

		this.tableContainer.setHeaderVisible(false);
		this.tableContainer.setBorders(false);
//		this.tableContainer.setLayout(new FitLayout());
//		this.tableContainer.setStyleAttribute("margin-top", "50px");
		inizializeTableTemplate();
		inizializeOperationsPanel();
	
		this.tableContainer.setScrollMode(Scroll.AUTOX);
		this.tableContainer.setEnabled(false);
		
		refreshSuggestion(TdTemplateConstants.SUGGESTION, "Please, set type to all columns");
//		suggestionContainer.getElement().getStyle().setBorderColor("#32CD32");

		tableContainer.setBodyBorder(false);
		tableContainer.setBorders(false);
		
		tableContainer.add(suggestionContainer);
		
		flexTableContainer.add(flexTableTemplate);
		tableContainer.add(flexTableContainer);
		
		
		String title = templateSwitcherInteface.getType() + " columns constraints";
		ConstraintSuggestionLabel cs = new ConstraintSuggestionLabel(title, templateSwitcherInteface.getTdTTemplateType().getConstraintDescription(), false);
//		tableContainer.add(cs.getAnchor());

		centralContainer.add(tableContainer);
		centralContainer.setBorders(false);
		centralContainer.add(cs);
		centralContainer.setScrollMode(Scroll.AUTOY);

		suggestionContainer.addListener(Events.Render, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				setBorderAsOnError(false);
				
			}
		});
		
		createBoderLayout();
		
//		enableFilter(false);
	}
	

	/**
	 * 
	 */
	private void createBoderLayout() {
		
		borderLayout = new BorderLayout();
		principalContainer = new ContentPanel(borderLayout);
		principalContainer.setHeaderVisible(false);

		centerData = new BorderLayoutData(LayoutRegion.CENTER);  
		centerData.setMargins(new Margins(0));		
		
	    southData = new BorderLayoutData(LayoutRegion.SOUTH, 200);  
	    southData.setSplit(true);  
	    southData.setCollapsible(true);  
	    southData.setFloatable(true);  
	    southData.setMargins(new Margins(5,0,0,0));  
//	    southData.setMaxSize(250);
//	    southData.setMinSize(50);
		southContainer = new ContentPanel();
		southContainer.setHeaderVisible(true);
		southContainer.setBorders(false);
		southContainer.setBodyBorder(false);
		southContainer.setHeading("Filters");
		southContainer.setScrollMode(Scroll.AUTOY);
		
		principalContainer.add(centralContainer, centerData);
//		principalContainer.add(southContainer, southData);
		
	}
	
	public void refreshSuggestion(String title, String text){
		suggestionContainer.setSuggestion(title, text);
		tableContainer.layout();
	}
	
	public void refreshSuggestion(String title, String text, AbstractImagePrototype img){
		suggestionContainer.setSuggestion(title, text,  "", img);
		tableContainer.layout();
	}

	public void setBorderAsOnError(boolean bool){
		
		if(suggestionContainer.isRendered() && suggestionContainer.getElement("body")!=null){
			if(bool)
				suggestionContainer.getElement("body").getStyle().setBorderColor("#FF2300");
			else
				suggestionContainer.getElement("body").getStyle().setBorderColor("#99BBE8");
		}
	}
	
//	private void setBodyColumnOpacity(FlexTable table, int colIndex, double opacity) {
//		for (int i = 1; i < table.getRowCount(); i++){
////			table.getCellFormatter().setVisible(i, colIndex, b);
//			table.getCellFormatter().getElement(i, colIndex).getStyle().setOpacity(opacity);
//		}
//	}
//	
	private void setColumnTypeOpacity(int row, int colIndex, double opacity) {
		flexTableTemplate.getCellFormatter().getElement(row, colIndex).getStyle().setOpacity(opacity);
	}
	
	private void setColumnTypeOpacity(int colIndex, double opacity) {
		setColumnTypeOpacity(1, colIndex, opacity);
	}


	
	/**
	 * 
	 */
	private void inizializeOperationsPanel() {
		
		ToolBar toolbar = new ToolBar();
		
//		ButtonGroup group = new ButtonGroup(1);  
//	    group.setHeading("Modify Column");  


		// Add a button that will add more rows to the table
	    Button addColumnButton = new Button("Add Column", TdTemplateAbstractResources.columnAdd());
		addColumnButton.setScale(ButtonScale.MEDIUM);
		addColumnButton.setIconAlign(IconAlign.TOP);
//		addColumnButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		
		addColumnButton.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {
				addColumn(flexTableTemplate);
				
			}
		});

		Button removeRowButton = new Button("Remove Column", TdTemplateAbstractResources.columnRemove());
		removeRowButton.setScale(ButtonScale.MEDIUM);
		removeRowButton.setIconAlign(IconAlign.TOP);
//		removeRowButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		
		removeRowButton.addSelectionListener(new SelectionListener<ButtonEvent>() {

			@Override
			public void componentSelected(ButtonEvent ce) {
				if(numColumns>1){
					removeColumn(flexTableTemplate, numColumns-1);
					setNumColumns(numColumns-1);
				}
				
			}
		});
		
		/*
		filterBySelection = new Button("Filter by Selection", TdTemplateAbstractResources.filter16());
		filterBySelection.setScale(ButtonScale.SMALL);
		filterBySelection.setIconAlign(IconAlign.LEFT);
		filterBySelection.setToolTip("Filter by Check Column");
//		removeRowButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		
		filterBySelection.addSelectionListener(new SelectionListener<ButtonEvent>() {

			@Override
			public void componentSelected(ButtonEvent ce) {

				List<ColumnElement> columnsSelected = new ArrayList<ColumnElement>();
				for (ColumnDefinitionView column : columnsDefined) {
					if(column.isSelected()){
//						column.setAsReadOnly(true);
//						setBodyColumnVisible(flexTableTemplate, column.getColumnIndex(), false);
						columnsSelected.add(column);
					}
				}
				
				if(columnsSelected.size()>0){
					MultiFilterByColumns multi;
					try {
				
						multi = new MultiFilterByColumns(columnsSelected);
//						multi.getWindow().show();
						LayoutContainer lc = multi.getPanel();
						lc.setStyleAttribute("margin-bottom", "2px");
						southContainer.add(lc);
						southContainer.layout(true);
					} catch (ColumnNotTypedException e) {
						MessageBox.info("Set data type!", "You must set the data type for selected column/s before to add a filter", null).show();
					}
			
				}else
					MessageBox.info("No selection", "You must select (through checkbox) at least one column", null).show();
				
			}
		});*/
		

		toolbar.add(addColumnButton);
		toolbar.add(new SeparatorMenuItem());
		toolbar.add(removeRowButton);
		
		toolbar.add(new FillToolItem());
		
//		toolbar.add(filterBySelection);
		tableContainer.setTopComponent(toolbar);
	}

	public void enableFilter(boolean bool){
//		filterBySelection.setEnabled(bool);
		
		if(!bool)
			borderLayout.collapse(LayoutRegion.SOUTH);
		else
			borderLayout.expand(LayoutRegion.SOUTH);
		
		southContainer.setEnabled(bool);
		
	
		/*
		if(!bool)
			borderLayout.collapse(LayoutRegion.SOUTH);
		else
			borderLayout.expand(LayoutRegion.SOUTH);
			
		borderLayout.layout();
		*/
//		southContainer.setVisible(bool);
	}
	
	public void enanbleColumnTypes(boolean bool){
//		flexTableContainer.setEnabled(bool);
		
		for (int i=0; i< columnsDefined.size(); i++) {
			ColumnDefinitionView column = columnsDefined.get(i);
			column.setColumnTypeAsReadOnly(!bool);
			
			if(bool)
				setColumnTypeOpacity(i, 1);
			else
				setColumnTypeOpacity(i, 0.5);
		}
	}
	
	/**
	 * Initialize this example.
	 */

	public void inizializeTableTemplate() {
		// Create a Flex Table
		flexTableTemplate.addStyleName("FlexTableTemplate");
		flexTableTemplate.ensureDebugId("cwFlexTable");
	}

	/**
	 * Add a row to the flex table.
	 */
	private void addRow(FlexTable flexTable) {
		int numRows = flexTable.getRowCount();
//		flexTable.setWidget(numRows, 0, new Image(ResourcesTemplate.INSTANCE.getArrowDown()));
//		flexTable.setWidget(numRows, 1, new Image(ResourcesTemplate.INSTANCE.getArrowDown()));
//		flexTable.getFlexCellFormatter().setRowSpan(0, 1, numRows + 1);
	}
	
	
	private void initTableColumns(FlexTable flexTable, int columnIndex, int columnsOffset){
		
		for (int i = 0; i < columnsOffset; i++) {
			
			int indexOffset = columnIndex+i;
			
			ColumnDefinitionView columnDef = new ColumnDefinitionView(this, indexOffset, new SetColumnTypeDialogManager(setColumnTypeDefinition.getListCategory(), controller));

			HorizontalPanel hp = new HorizontalPanel();
			hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);

			hp.add(columnDef.getSetColumnTypeViewManager().getTypingContainer());

			flexTable.setWidget(0, indexOffset, columnDef.getColumnHeaderValue());
			flexTable.setWidget(1, indexOffset, hp);
			
			flexTable.setWidget(2, indexOffset, columnDef.getColumnDescription());
			flexTable.getCellFormatter().getElement(2, indexOffset).setAttribute("height", "40px");
			
			
			HTMLTable.RowFormatter rf = flexTable.getRowFormatter();
			rf.addStyleName(0, "FlexTableTemplate-header-row");
			rf.addStyleName(1, "FlexTableTemplate-other-rows");
			rf.addStyleName(2, "FlexTableTemplate-other-rows");

			try{
				GWT.log("Setting indexOffset: "+indexOffset);
				columnsDefined.set(indexOffset, columnDef);
				
			}catch (Exception e) {
				GWT.log("Warn: indexOffset "+indexOffset +" doesn't exists into columnsDefined adding");
		
				columnsDefined.add(indexOffset, columnDef);
			}
		}
		
	}
	
	public void setWidgetIntoTable(int rowIndex, int columnIndex, Widget widget){
		HTMLTable.RowFormatter rf = flexTableTemplate.getRowFormatter();
		
		if(rowIndex>0)
			rf.addStyleName(rowIndex, "FlexTableTemplate-other-rows");
		
		flexTableTemplate.setWidget(rowIndex, columnIndex, widget);
		
	}
	
	public void clearCell(int rowIndex, int columnIndex){
		
		try{
			GWT.log("Clear cell rowIndex, "+rowIndex+", column index "+columnIndex);
			flexTableTemplate.clearCell(rowIndex, columnIndex);	
		}catch (Exception e) {
			GWT.log("Last remove cell throw exception");
		}
	}
	
	
	/**
	 * Add a row to the flex table.
	 */
	private void addColumn(FlexTable flexTable) {

		initTableColumns(flexTable, numColumns, 1);
		setNumColumns(numColumns+1);
		validateTemplate();
	}
	

	/**
	 * @param numColumns
	 */
	private void setNumColumns(int numColumns) {
		this.numColumns = numColumns;
		
	}


	private void addHeaderColumns(FlexTable flexTable) {
		int numRows = flexTable.getRowCount();
		
		int numColumns = flexTable.getCellCount(numRows);
		
		for (int i = 0; i < numColumns; i++) {
			flexTable.setWidget(1, i, new Label("Column "+i+1));
		}
	}
	
	/**
	 * Remove a row from the flex table.
	 */
	private void removeColumn(FlexTable flexTable, int columnIndex) {

	
		GWT.log("Remove column at index: "+columnIndex);
		
		if (columnIndex > 0) {
			int numRows = flexTable.getRowCount();
			GWT.log("Current Table row size: "+numRows);
			try{
				for (int i=0; i<numRows; i++) {
					GWT.log("RemoveCell i, "+i+", column index "+columnIndex);
					flexTable.removeCell(i, columnIndex);
				}
			}catch (Exception e) {
				GWT.log("Last remove cell throw exception");
			}
	
			GWT.log("Remove column defined at index: "+columnIndex);
			columnsDefined.remove(columnIndex);
			validateTemplate();
//			flexTable.getFlexCellFormatter().setRowSpan(0, 1, columnIndex - 1);
		}
	}

	/**
	 * Remove a row from the flex table.
	 */
	private void removeRow(FlexTable flexTable) {
		int numRows = flexTable.getRowCount();
		if (numRows > 1) {
			flexTable.removeRow(numRows - 1);
			flexTable.getFlexCellFormatter().setRowSpan(0, 1, numRows - 1);
		}
	}


	public int getNumColumns() {
		return numColumns;
	}


	public LayoutContainer getPanel() {
		return principalContainer;
	}


	public List<ColumnDefinitionView> getColumnsDefined() {
		return columnsDefined;
	}
	

	public void validateTemplate() {
		
		boolean isValid = true;
		for (ColumnDefinitionView col : columnsDefined) {
			if(!col.isValid()){
				isValid = false;
				refreshSuggestion(TdTemplateConstants.SUGGESTION, TdTemplateConstants.PLEASE_SET_TYPE_TO_COLUMN_NUMBER+(col.getColumnIndex()+1));
				TdTemplateController.getInternalBus().fireEvent(new TemplateComplitedEvent(false));
//				enableFilter(false);
//				resetFilterPanel();
				break;
			}
		}
		
		if(isValid){
			refreshSuggestion(TdTemplateConstants.TEMPLATE_COMPLETED, TdTemplateConstants.NOW_IS_POSSIBLE_TO_SAVE_THE_TEMPLATE_CREATED, TdTemplateAbstractResources.handsUP());
			TdTemplateController.getInternalBus().fireEvent(new TemplateComplitedEvent(true));
			/*enableFilter(true);
			enanbleColumnTypes(false);
			BaloonPanel baloonPanel = new BaloonPanel("Do you want add filters?", true);
			int zIndex = controller.getWindowZIndex();
			int zi = zIndex+1;
			baloonPanel.getElement().getStyle().setZIndex(zi);
			baloonPanel.showRelativeTo(southContainer);
			*/
//			setCheckColumnsEnabled(true);
		}
	}
}
