/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client.template.view;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.tdtemplate.client.TdTemplateConstants;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;
import org.gcube.portlets.user.tdtemplate.client.event.SetColumnTypeCompletedEvent;
import org.gcube.portlets.user.tdtemplate.client.event.TemplateComplitedEvent;
import org.gcube.portlets.user.tdtemplate.client.resources.TdTemplateAbstractResources;
import org.gcube.portlets.user.tdtemplate.client.template.SetColumnTypeDefinition;
import org.gcube.portlets.user.tdtemplate.client.template.SetColumnTypeDialogManager;
import org.gcube.portlets.user.tdtemplate.client.template.view.suggestion.ConstraintSuggestionLabel;
import org.gcube.portlets.user.tdtemplate.client.template.view.suggestion.SuggestionContainer;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.Style.IconAlign;
import com.extjs.gxt.ui.client.Style.LayoutRegion;
import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonGroup;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.menu.SeparatorMenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jan 8, 2014
 *
 */
public class TemplatePanel {
	
	protected FlexTable flexTableTemplate = new FlexTable();
	private int numColumns;
	protected ContentPanel tableContainer = new ContentPanel();
	private SuggestionContainer suggestionContainer = new SuggestionContainer();
	
	protected List<ColumnDefinitionView> columnsDefined;
	private TemplateSwitcherInteface templateSwitcherInteface;
	protected SetColumnTypeDefinition setColumnTypeDefinition;
	private TdTemplateController controller;
	
	private LayoutContainer centralContainer = new LayoutContainer();
	
	private ContentPanel principalContainer;
	private ContentPanel southContainer;
//	private Button filterBySelection;
	private BorderLayout borderLayout;
	
	private List<CheckBox> listChecks = new ArrayList<CheckBox>();
	
	/**
	 * @param setColumnTypeDefinition 
	 * 
	 */
	public TemplatePanel(TemplateSwitcherInteface templateSwitcherInteface, TdTemplateController controller) {
		this.numColumns = templateSwitcherInteface.getNumberOfColumns();
		this.controller = controller;
		this.templateSwitcherInteface = templateSwitcherInteface;
		this.columnsDefined = new ArrayList<ColumnDefinitionView>(numColumns);
	
		setColumnTypeDefinition = new SetColumnTypeDefinition(templateSwitcherInteface) {
			
			@Override
			public void updateListCategory() {
				GWT.log("Init table");
				tableContainer.setEnabled(true);
				initTableColumns(flexTableTemplate, 0, numColumns);
				TdTemplateController.getInternalBus().fireEvent(new SetColumnTypeCompletedEvent());
			}
		};
		

		this.tableContainer.setHeaderVisible(false);
		this.tableContainer.setBorders(false);
//		this.tableContainer.setLayout(new FitLayout());
//		this.tableContainer.setStyleAttribute("margin-top", "50px");
		inizializeTableTemplate();
		inizializeOperationsPanel();
	
		this.tableContainer.setScrollMode(Scroll.AUTOX);
		this.tableContainer.setEnabled(false);
		
		refreshSuggestion(TdTemplateConstants.SUGGESTION, "Please, set type to all columns");
//		suggestionContainer.getElement().getStyle().setBorderColor("#32CD32");

		tableContainer.setBodyBorder(false);
		tableContainer.setBorders(false);
		
		tableContainer.add(suggestionContainer);
		tableContainer.add(flexTableTemplate);
		
		
		String title = templateSwitcherInteface.getType() + " columns constraints";
		ConstraintSuggestionLabel cs = new ConstraintSuggestionLabel(title, templateSwitcherInteface.getTdTTemplateType().getConstraintDescription(), false);
//		tableContainer.add(cs.getAnchor());

		centralContainer.add(tableContainer);
		centralContainer.setBorders(false);
		centralContainer.add(cs);
		centralContainer.setScrollMode(Scroll.AUTOY);

		suggestionContainer.addListener(Events.Render, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				setBorderAsOnError(false);
				
			}
		});
		
		createBoderLayout();
		
	}
	
	/**
	 * 
	 */
	private void createBoderLayout() {
		
		borderLayout = new BorderLayout();
		principalContainer = new ContentPanel(borderLayout);
		principalContainer.setHeaderVisible(false);

		BorderLayoutData centerData = new BorderLayoutData(LayoutRegion.CENTER);  
		centerData.setMargins(new Margins(0));		
		
	    BorderLayoutData southData = new BorderLayoutData(LayoutRegion.SOUTH, 200);  
	    southData.setSplit(true);  
	    southData.setCollapsible(true);  
	    southData.setFloatable(true);  
	    southData.setMargins(new Margins(5,0,0,0));  
//	    southData.setMaxSize(250);
//	    southData.setMinSize(50);
		southContainer = new ContentPanel();
		southContainer.setHeaderVisible(true);
		southContainer.setBorders(false);
		southContainer.setHeading("Filter");
		southContainer.setScrollMode(Scroll.AUTOY);
		
		principalContainer.add(centralContainer, centerData);
		principalContainer.add(southContainer, southData);
		
//		principalContainer.setHeight("200px");
		
		southContainer.setVisible(false);

	}
	
	public void refreshSuggestion(String title, String text){
		suggestionContainer.setSuggestion(title, text);
		tableContainer.layout();
	}
	
	public void refreshSuggestion(String title, String text, AbstractImagePrototype img){
		suggestionContainer.setSuggestion(title, text,  "", img);
		tableContainer.layout();
	}

	public void setBorderAsOnError(boolean bool){
		
		if(suggestionContainer.isRendered() && suggestionContainer.getElement("body")!=null){
			if(bool)
				suggestionContainer.getElement("body").getStyle().setBorderColor("#FF2300");
			else
				suggestionContainer.getElement("body").getStyle().setBorderColor("#99BBE8");
		}
	}
	
	/**
	 * 
	 */
	private void inizializeOperationsPanel() {
		
		ToolBar toolbar = new ToolBar();
		
		ButtonGroup group = new ButtonGroup(1);  
	    group.setHeading("Modify Column");  


		// Add a button that will add more rows to the table
	    Button addColumnButton = new Button("Add Column", TdTemplateAbstractResources.columnAdd());
		addColumnButton.setScale(ButtonScale.MEDIUM);
		addColumnButton.setIconAlign(IconAlign.TOP);
//		addColumnButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		
		addColumnButton.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {
				addColumn(flexTableTemplate);
				
			}
		});

		Button removeRowButton = new Button("Remove Column", TdTemplateAbstractResources.columnRemove());
		removeRowButton.setScale(ButtonScale.MEDIUM);
		removeRowButton.setIconAlign(IconAlign.TOP);
//		removeRowButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		
		removeRowButton.addSelectionListener(new SelectionListener<ButtonEvent>() {

			@Override
			public void componentSelected(ButtonEvent ce) {
				if(numColumns>1){
					removeColumn(flexTableTemplate, numColumns-1);
					setNumColumns(numColumns-1);
				}
				
			}
		});
		

		toolbar.add(addColumnButton);
		toolbar.add(new SeparatorMenuItem());
		toolbar.add(removeRowButton);
		tableContainer.setTopComponent(toolbar);
	}


	/**
	 * Initialize this example.
	 */

	public void inizializeTableTemplate() {
		// Create a Flex Table
		flexTableTemplate.addStyleName("FlexTableTemplate");
//		initTableColumns(flexTableTemplate, 0, numColumns);
		
		flexTableTemplate.ensureDebugId("cwFlexTable");
	}

	/**
	 * Add a row to the flex table.
	 */
	private void addRow(FlexTable flexTable) {
		int numRows = flexTable.getRowCount();
//		flexTable.setWidget(numRows, 0, new Image(ResourcesTemplate.INSTANCE.getArrowDown()));
//		flexTable.setWidget(numRows, 1, new Image(ResourcesTemplate.INSTANCE.getArrowDown()));
//		flexTable.getFlexCellFormatter().setRowSpan(0, 1, numRows + 1);
	}
	
	
	private void initTableColumns(FlexTable flexTable, int columnIndex, int columnsOffset){
		
		for (int i = 0; i < columnsOffset; i++) {
			
			int indexOffset = columnIndex+i;
			
			ColumnDefinitionView columnDef = new ColumnDefinitionView(this, indexOffset, new SetColumnTypeDialogManager(setColumnTypeDefinition.getListCategory(), controller));

			HorizontalPanel hp = new HorizontalPanel();
			hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);

			hp.add(columnDef.getSetColumnTypeViewManager().getTypingContainer());

			CheckBox check = new CheckBox();
			check.setStyleAttribute("margin-right", "10px");
			
			/*HorizontalPanel hp2 = new HorizontalPanel();
			hp2.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
			hp2.add(check);
			hp2.add(columnDef.getColumnHeaderValue());
			flexTable.setWidget(0, indexOffset, hp2);*/
			
			flexTable.setWidget(0, indexOffset, columnDef.getColumnHeaderValue());
			flexTable.setWidget(1, indexOffset, hp);
			
			flexTable.setWidget(2, indexOffset, columnDef.getColumnDescription());
			flexTable.getCellFormatter().getElement(2, indexOffset).setAttribute("height", "40px");
			
			
			HTMLTable.RowFormatter rf = flexTable.getRowFormatter();
			rf.addStyleName(0, "FlexTableTemplate-header-row");
			rf.addStyleName(1, "FlexTableTemplate-other-rows");
			rf.addStyleName(2, "FlexTableTemplate-other-rows");

//			//TODO
//			int size = columnsDefined.size();
//			if(size>0 && indexOffset<size && columnsDefined.get(indexOffset)!=null)
//				columnsDefined.set(indexOffset, columnDef);
//			else
//				columnsDefined.add(indexOffset, columnDef);
			
			try{
				GWT.log("Setting indexOffset: "+indexOffset);
				columnsDefined.set(indexOffset, columnDef);
				
			}catch (Exception e) {
				GWT.log("Warn: indexOffset "+indexOffset +" doesn't exists into columnsDefined adding");
		
				columnsDefined.add(indexOffset, columnDef);
			}
		}
		
	}
	
	public void setWidgetIntoTable(int rowIndex, int columnIndex, Widget widget){
		HTMLTable.RowFormatter rf = flexTableTemplate.getRowFormatter();
		
		if(rowIndex>0)
			rf.addStyleName(rowIndex, "FlexTableTemplate-other-rows");
		
		flexTableTemplate.setWidget(rowIndex, columnIndex, widget);
		
	}
	
	public void clearCell(int rowIndex, int columnIndex){
		
		try{
			GWT.log("Clear cell rowIndex, "+rowIndex+", column index "+columnIndex);
			flexTableTemplate.clearCell(rowIndex, columnIndex);	
		}catch (Exception e) {
			GWT.log("Last remove cell throw exception");
		}
	}
	
	
	/**
	 * Add a row to the flex table.
	 */
	private void addColumn(FlexTable flexTable) {
		
//		int numRows = flexTable.getRowCount();
//		int numColumns = flexTable.getCellCount(0);

		initTableColumns(flexTable, numColumns, 1);
		
		setNumColumns(numColumns+1);
		
		validateTemplate();
		
//		flexTable.getFlexCellFormatter().setColSpan(0, 1, numRows + 1);
	}
	

	/**
	 * @param numColumns
	 */
	private void setNumColumns(int numColumns) {
		this.numColumns = numColumns;
		
	}


	private void addHeaderColumns(FlexTable flexTable) {
		int numRows = flexTable.getRowCount();
		
		int numColumns = flexTable.getCellCount(numRows);
		
		for (int i = 0; i < numColumns; i++) {
			flexTable.setWidget(1, i, new Label("Column "+i+1));
		}
	}
	
	/**
	 * Remove a row from the flex table.
	 */
	private void removeColumn(FlexTable flexTable, int columnIndex) {

	
		GWT.log("Remove column at index: "+columnIndex);
		
		if (columnIndex > 0) {
			int numRows = flexTable.getRowCount();
			GWT.log("Current Table row size: "+numRows);
			try{
				for (int i=0; i<numRows; i++) {
					GWT.log("RemoveCell i, "+i+", column index "+columnIndex);
					flexTable.removeCell(i, columnIndex);
				}
			}catch (Exception e) {
				GWT.log("Last remove cell throw exception");
			}
	
			GWT.log("Remove column defined at index: "+columnIndex);
			columnsDefined.remove(columnIndex);
			validateTemplate();
//			flexTable.getFlexCellFormatter().setRowSpan(0, 1, columnIndex - 1);
		}
	}

	/**
	 * Remove a row from the flex table.
	 */
	private void removeRow(FlexTable flexTable) {
		int numRows = flexTable.getRowCount();
		if (numRows > 1) {
			flexTable.removeRow(numRows - 1);
			flexTable.getFlexCellFormatter().setRowSpan(0, 1, numRows - 1);
		}
	}


	public int getNumColumns() {
		return numColumns;
	}


	public LayoutContainer getPanel() {
		return principalContainer;
	}


	public List<ColumnDefinitionView> getColumnsDefined() {
		return columnsDefined;
	}


	public void validateTemplate() {
		
		boolean isValid = true;
		for (ColumnDefinitionView col : columnsDefined) {
			if(!col.isValid()){
				isValid = false;
				refreshSuggestion(TdTemplateConstants.SUGGESTION, TdTemplateConstants.PLEASE_SET_TYPE_TO_COLUMN_NUMBER+(col.getColumnIndex()+1));
				TdTemplateController.getInternalBus().fireEvent(new TemplateComplitedEvent(false));
//				enableFilter(false);
//				resetFilterPanel();
				break;
			}
		}
		
		if(isValid){
			refreshSuggestion(TdTemplateConstants.TEMPLATE_COMPLETED, TdTemplateConstants.NOW_IS_POSSIBLE_TO_SAVE_THE_TEMPLATE_CREATED, TdTemplateAbstractResources.handsUP());
			TdTemplateController.getInternalBus().fireEvent(new TemplateComplitedEvent(true));
//			enableFilter(true);
//			BaloonPanel baloonPanel = new BaloonPanel("Do you want add filters?", true);
//			int zIndex = controller.getWindowZIndex();
//			int zi = zIndex+1;
//			baloonPanel.getElement().getStyle().setZIndex(zi);
//			baloonPanel.showRelativeTo(southContainer);
//			setCheckColumnsEnabled(true);
		}
	}
}
