/**
 * 
 */
package org.gcube.portlets.user.tdtemplate.client;

import org.gcube.portlets.user.tdtemplate.client.event.ExpressionDialogOpenedEvent;
import org.gcube.portlets.user.tdtemplate.client.event.ExpressionDialogOpenedEventHandler;
import org.gcube.portlets.user.tdtemplate.client.event.SetColumnTypeCompletedEvent;
import org.gcube.portlets.user.tdtemplate.client.event.SetColumnTypeCompletedEventHandler;
import org.gcube.portlets.user.tdtemplate.client.event.TemplateComplitedEvent;
import org.gcube.portlets.user.tdtemplate.client.event.TemplateComplitedEventHandler;
import org.gcube.portlets.user.tdtemplate.client.event.TemplateSelectedEvent;
import org.gcube.portlets.user.tdtemplate.client.event.TemplateSelectedEventHandler;

import com.google.gwt.core.client.GWT;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.SimpleEventBus;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Mar 27, 2014
 *
 */
public class TdTemplatePrivateEventsBinder {

	public static EventBus privateTaskBus = new SimpleEventBus();
	private TdTemplateControllerState templateControllerState;
	
	public TdTemplatePrivateEventsBinder(){
	}
	
	protected void bindEvents(TdTemplateControllerState controllerState){
		this.templateControllerState = controllerState;
		
		privateTaskBus.addHandler(TemplateSelectedEvent.TYPE, new TemplateSelectedEventHandler() {
			
			@Override
			public void onTemplateSelectedEvent(TemplateSelectedEvent event) {

				templateControllerState.doInitTemplate(event.getSwitcher());
			}

		});
		
		privateTaskBus.addHandler(TemplateComplitedEvent.TYPE, new TemplateComplitedEventHandler() {
			
			@Override
			public void onTemplateComplitedEvent(TemplateComplitedEvent templateValidEvent) {
				templateControllerState.getSubmitTool().setEnabled(templateValidEvent.isCompleted());
				
			}
			
		});
		
		privateTaskBus.addHandler(ExpressionDialogOpenedEvent.TYPE, new ExpressionDialogOpenedEventHandler() {
			
		

			@Override
			public void onExpressionDialogOpen(ExpressionDialogOpenedEvent expressionDialogEvent) {
				
				if(expressionDialogEvent!=null && expressionDialogEvent.getColumnId()!=-1){
//					int columId = templateControllerState.getExpressionDialogIndexUpdate();
//					columId = expressionDialogEvent.getColumnId();
//					GWT.log("Updated expression dialog open as index "+templateControllerState.getExpressionDialogIndexUpdate());
					
					int columId  = expressionDialogEvent.getColumnId();
					templateControllerState.setExpressionDialogIndexUpdate(columId);
					GWT.log("Updated expression dialog open as index "+columId);
				}
				
			}
		});
		
		privateTaskBus.addHandler(SetColumnTypeCompletedEvent.TYPE, new SetColumnTypeCompletedEventHandler() {
			
			@Override
			public void onSetTypeCompleted(SetColumnTypeCompletedEvent setColumnTypeCompletedEvent) {
				templateControllerState.doUpdateTemplate();
				
			}
		});
		
	}
}
